/*
 * Decompiled with CFR 0.152.
 */
package org.zinutils.bytecode;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.zinutils.bytecode.AnnotationArg;
import org.zinutils.bytecode.AnnotationValue;
import org.zinutils.bytecode.AttributeInfo;
import org.zinutils.bytecode.ByteCodeFile;
import org.zinutils.bytecode.CPInfo;
import org.zinutils.bytecode.JavaInfo;
import org.zinutils.exceptions.UtilException;

public class Annotation {
    private final ByteCodeFile bcf;
    final String name;
    private final List<AnnotationArg> args = new ArrayList<AnnotationArg>();
    private final int param;

    public Annotation(ByteCodeFile bcf, String name) {
        this(bcf, name, -1);
    }

    public Annotation(ByteCodeFile bcf, String name, int param) {
        this.bcf = bcf;
        this.name = name;
        this.param = param;
    }

    public Annotation(ByteCodeFile bcf, String name, List<AnnotationArg> args) {
        this.bcf = bcf;
        this.name = name;
        this.args.addAll(args);
        this.param = -1;
    }

    public static List<Annotation> parse(ByteCodeFile bcf, AttributeInfo attr) {
        byte[] bs = attr.getBytes();
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(bs));
        return Annotation.parse(bcf, dis);
    }

    public static List<Annotation> parse(ByteCodeFile bcf, DataInputStream dis) {
        try {
            ArrayList<Annotation> ret = new ArrayList<Annotation>();
            int cnt = dis.readShort();
            for (int i = 0; i < cnt; ++i) {
                ret.add(Annotation.parseOne(bcf, dis));
            }
            return ret;
        }
        catch (Exception ex) {
            throw UtilException.wrap(ex);
        }
    }

    static Annotation parseOne(ByteCodeFile bcf, DataInputStream dis) throws IOException {
        short idx = dis.readShort();
        String name = JavaInfo.unmap(((CPInfo.Utf8Info)bcf.pool.get(idx)).asString());
        int argcnt = dis.readShort();
        ArrayList<AnnotationArg> args = new ArrayList<AnnotationArg>();
        for (int j = 0; j < argcnt; ++j) {
            args.add(AnnotationArg.readArg(bcf, dis));
        }
        Annotation abb = new Annotation(bcf, name, args);
        return abb;
    }

    public void write(DataOutputStream dos) throws IOException {
        dos.writeShort(this.bcf.pool.requireUtf8(JavaInfo.map(this.name)));
        dos.writeShort(this.args.size());
        for (AnnotationArg a : this.args) {
            a.write(dos);
        }
    }

    public void addParam(String paramName, String paramValue) {
        this.args.add(new AnnotationArg(this.bcf, paramName, paramValue));
    }

    public void addParam(String paramName, String[] paramValue) {
        this.args.add(new AnnotationArg(this.bcf, paramName, paramValue));
    }

    public void addClassParam(String paramName, String className) {
        this.args.add(AnnotationArg.classParam(this.bcf, paramName, className));
    }

    public void addClassParams(String paramName, String ... classes) {
        this.args.add(AnnotationArg.classArray(this.bcf, paramName, classes));
    }

    public void addEnumParam(Enum<?> e) {
        this.args.add(AnnotationArg.value(this.bcf, "value", e));
    }

    public void addAnnParam(String paramName, Annotation ... args) {
        this.args.add(AnnotationArg.annArray(this.bcf, paramName, args));
    }

    public int forParam() {
        return this.param;
    }

    public String toString() {
        return "Annotation[" + this.name + ":" + this.args + "]";
    }

    public AnnotationValue getArg(String string) {
        for (AnnotationArg a : this.args) {
            if (!a.name.equals(string)) continue;
            return a.value;
        }
        return null;
    }
}

