/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.splitter;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.ziniki.splitter.ConcreteMetaData;
import org.ziniki.splitter.JsoupSplitter;
import org.ziniki.splitter.SplitMetaData;
import org.zinutils.utils.FileUtils;

public class Splitter {
    private final Consumer<SplitterError> errorHandler;

    public Splitter(Consumer<SplitterError> errorHandler) {
        this.errorHandler = errorHandler;
    }

    public SplitMetaData split(File web) throws IOException {
        File tmp = File.createTempFile("webdata", ".zip");
        FileOutputStream baos = new FileOutputStream(tmp);
        ZipOutputStream zos = new ZipOutputStream(baos);
        ConcreteMetaData smd = new ConcreteMetaData();
        for (File f : FileUtils.findFilesUnderMatching((File)web, (String)"*")) {
            File af = new File(web, f.getPath());
            if (af.isDirectory()) continue;
            try (FileInputStream zis = new FileInputStream(af);){
                this.splitFile(smd, zos, zis, f.getPath());
            }
        }
        zos.close();
        smd.stream(tmp);
        return smd;
    }

    public SplitMetaData split(OutputStream dest, InputStream src) throws IOException {
        ZipEntry ze;
        ConcreteMetaData smd = new ConcreteMetaData();
        ZipOutputStream zos = new ZipOutputStream(dest);
        ZipInputStream zis = new ZipInputStream(src);
        while ((ze = zis.getNextEntry()) != null) {
            this.splitFile(smd, zos, zis, ze.getName());
        }
        zos.close();
        return smd;
    }

    private void splitFile(SplitMetaData smd, ZipOutputStream zos, InputStream zis, String name) throws IOException {
        if (name.endsWith(".html")) {
            this.processHTML(name, smd, zos, zis);
        } else {
            zos.putNextEntry(new ZipEntry(name));
            FileUtils.copyStreamWithoutClosingEither((InputStream)zis, (OutputStream)zos);
        }
        zos.closeEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processHTML(String fileName, SplitMetaData smd, ZipOutputStream zos, InputStream zis) throws IOException {
        File tmp = File.createTempFile("splitme", ".html");
        try {
            try (FileOutputStream fos = new FileOutputStream(tmp);){
                FileUtils.copyStreamWithoutClosingEither((InputStream)zis, (OutputStream)fos);
            }
            Document doc = Jsoup.parse((String)FileUtils.readFile((File)tmp));
            Element body = doc.body();
            JsoupSplitter splitter = new JsoupSplitter(this.errorHandler, smd, zos);
            splitter.split(fileName, body);
        }
        finally {
            tmp.delete();
        }
    }

    public static class SplitterError {
        public final String file;
        public final String message;
        public final String text;

        public SplitterError(String file, String message, String text) {
            this.file = file;
            this.message = message;
            this.text = text;
        }
    }
}

