/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.splitter;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.parser.Tag;
import org.ziniki.splitter.CardType;
import org.ziniki.splitter.ConcreteMetaData;
import org.ziniki.splitter.FieldType;
import org.ziniki.splitter.LocalMetaData;
import org.ziniki.splitter.SplitMetaData;
import org.ziniki.splitter.Splitter;

public class JsoupSplitter {
    private final Consumer<Splitter.SplitterError> errorHandler;
    private final ConcreteMetaData smd;
    private final ZipOutputStream zos;
    private String fileName;
    private List<Todo> todo;

    public JsoupSplitter(Consumer<Splitter.SplitterError> errorHandler, SplitMetaData smd, ZipOutputStream zos) {
        this.errorHandler = errorHandler;
        this.smd = (ConcreteMetaData)smd;
        this.zos = zos;
    }

    public void split(String fileName, Element body) {
        this.fileName = fileName;
        this.todo = new ArrayList<Todo>();
        this.recsplit(body, null, "");
        while (!this.todo.isEmpty()) {
            Todo hd = this.todo.remove(0);
            this.recsplit(hd.elt, hd.lmd, "");
        }
    }

    private void recsplit(Element elt, LocalMetaData md, String fileLabel) {
        for (int i = 0; i < elt.children().size(); ++i) {
            LocalMetaData lmd = md;
            Element c = elt.child(i);
            try {
                if (c.hasAttr("id")) {
                    String etext = JsoupSplitter.captureText(c);
                    String id = c.attr("id");
                    c.removeAttr("id");
                    String saveAs = null;
                    if (id.startsWith("flas-card-")) {
                        saveAs = id.replace("flas-card-", "cards/");
                        lmd = new LocalMetaData();
                    } else if (id.startsWith("flas-item-")) {
                        saveAs = id.replace("flas-item-", "items/");
                        lmd = new LocalMetaData();
                    } else if (id.startsWith("flas-content-")) {
                        String type;
                        pid = id.replace("flas-content-", "");
                        if (c.tagName().equalsIgnoreCase("img")) {
                            Element ps = new Element(Tag.valueOf((String)"span"), c.baseUri());
                            ps.attr("class", "flas-image-parent");
                            int k = c.siblingIndex();
                            c.parent().insertChildren(k, Arrays.asList(ps));
                            c.remove();
                            ps.appendChild((Node)c);
                            type = "image";
                        } else {
                            type = c.tagName().equalsIgnoreCase("a") ? "link" : "content";
                        }
                        if (!this.bindIt(this.fileName, md, fileLabel, c, etext, pid, type)) continue;
                        this.addTodo(this.todo, c, md);
                    } else if (id.startsWith("flas-style-")) {
                        pid = id.replace("flas-style-", "");
                        if (!this.bindIt(this.fileName, md, fileLabel, c, etext, pid, "style")) {
                            continue;
                        }
                    } else if (id.startsWith("flas-punnet-")) {
                        pid = id.replace("flas-punnet-", "");
                        if (!this.bindIt(this.fileName, md, fileLabel, c, etext, pid, "punnet")) continue;
                        this.addTodo(this.todo, c, md);
                    } else if (id.startsWith("flas-container-")) {
                        pid = id.replace("flas-container-", "");
                        if (!this.bindIt(this.fileName, md, fileLabel, c, etext, pid, "container")) continue;
                        this.addTodo(this.todo, c, md);
                    }
                    this.recsplit(c, lmd, saveAs != null ? saveAs : fileLabel);
                    if (saveAs == null) continue;
                    this.save(this.fileName, saveAs + ".html", JsoupSplitter.getWholeText(c), "");
                    this.save(this.fileName, saveAs + ".json", lmd.toJSON(), "");
                    continue;
                }
                this.recsplit(c, lmd, fileLabel);
                continue;
            }
            catch (JSONException ex) {
                this.errorHandler.accept(new Splitter.SplitterError(this.fileName, "error in JSON", ex.getMessage()));
            }
        }
    }

    private void addTodo(List<Todo> todo, Element c, LocalMetaData lmd) {
        Element frag = new Element(Tag.valueOf((String)"frag"), c.baseUri());
        while (c.childNodeSize() > 0) {
            Node child = c.childNode(0);
            child.remove();
            frag.appendChild(child);
        }
        if (frag.childNodeSize() > 0) {
            todo.add(new Todo(lmd, frag));
        }
    }

    private boolean bindIt(String fileName, LocalMetaData md, String fileLabel, Element c, String etext, String pid, String type) throws JSONException {
        if (md == null) {
            this.errorHandler.accept(new Splitter.SplitterError(fileName, "field declaration not in card or item: " + pid, etext));
            return false;
        }
        if (md.has(pid)) {
            this.errorHandler.accept(new Splitter.SplitterError(fileName, "duplicate field in '" + fileLabel + "': " + pid, etext));
            return false;
        }
        md.set(pid, type);
        c.attr("data-flas-" + type, pid);
        return true;
    }

    private static String captureText(Element c) {
        return JsoupSplitter.captureTextElts(c)[0];
    }

    private static String[] captureTextElts(Element c) {
        Element cln = c.clone();
        while (cln.childNodeSize() > 0) {
            cln.childNode(0).remove();
        }
        String ret = cln.toString();
        int idx = ret.lastIndexOf("</");
        if (idx == -1) {
            return new String[]{ret, ""};
        }
        return new String[]{ret.substring(0, idx), ret.substring(idx)};
    }

    public static String getWholeText(Element cell) {
        StringBuilder textBuilder = new StringBuilder();
        JsoupSplitter.getWholeText(textBuilder, cell);
        return textBuilder.toString();
    }

    public static void getWholeText(StringBuilder textBuilder, Element cell) {
        String[] me = JsoupSplitter.captureTextElts(cell);
        textBuilder.append(me[0]);
        for (Node node : cell.childNodes()) {
            if (node instanceof TextNode) {
                textBuilder.append(((TextNode)node).getWholeText());
                continue;
            }
            if (node instanceof Element) {
                JsoupSplitter.getWholeText(textBuilder, (Element)node);
                continue;
            }
            textBuilder.append(node.outerHtml());
        }
        textBuilder.append(me[1]);
    }

    public void save(String processing, String name, String content, String errors) {
        try {
            JSONArray ja;
            if (errors != null && errors.length() > 0 && (ja = new JSONArray(errors)).length() > 0) {
                for (int i = 0; i < ja.length(); i += 2) {
                    this.errorHandler.accept(new Splitter.SplitterError(name, ja.getString(i), ja.getString(i + 1)));
                }
            }
            if (name.endsWith(".json")) {
                JSONObject json = new JSONObject(content);
                String label = name.replaceFirst("\\.json", "");
                int idx = label.indexOf("/");
                CardType cardType = CardType.valueOf(label.substring(0, idx - 1).toUpperCase());
                String cardName = label.substring(idx + 1);
                if (this.smd.has(cardName)) {
                    this.errorHandler.accept(new Splitter.SplitterError(processing, "duplicate entry name " + cardName, null));
                }
                TreeMap<String, FieldType> entries = new TreeMap<String, FieldType>();
                Iterator keys = json.keys();
                while (keys.hasNext()) {
                    String k = (String)keys.next();
                    entries.put(k, FieldType.valueOf(json.getString(k).toUpperCase()));
                }
                this.smd.add(cardType, cardName, entries);
            }
            ZipEntry ze = new ZipEntry(name);
            ze.setSize(content.length());
            this.smd.setLength(name, content.length());
            this.zos.putNextEntry(ze);
            this.zos.write(content.getBytes(Charset.forName("UTF-8")));
        }
        catch (IOException | JSONException e) {
            this.errorHandler.accept(new Splitter.SplitterError(name, e.getMessage(), ""));
        }
    }

    public class Todo {
        LocalMetaData lmd;
        Element elt;

        public Todo(LocalMetaData lmd, Element elt) {
            this.lmd = lmd;
            this.elt = elt;
        }
    }
}

