/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.splitter;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.ZipInputStream;
import org.codehaus.jettison.json.JSONException;
import org.ziniki.splitter.CardData;
import org.ziniki.splitter.CardEntry;
import org.ziniki.splitter.CardType;
import org.ziniki.splitter.FieldType;
import org.ziniki.splitter.NoMetaDataException;
import org.ziniki.splitter.SplitMetaData;

public class ConcreteMetaData
implements SplitMetaData {
    private final Map<String, CardData> cards = new TreeMap<String, CardData>();
    private final Map<String, Long> lengths = new TreeMap<String, Long>();
    private File processedZip;

    @Override
    public ZipInputStream processedZip() throws FileNotFoundException {
        return new ZipInputStream(new FileInputStream(this.processedZip));
    }

    public void stream(File processedZip) {
        this.processedZip = processedZip;
    }

    @Override
    public CardData forCard(String card) {
        CardData ret = this.cards.get(card);
        if (ret == null) {
            throw new NoMetaDataException(card);
        }
        return ret;
    }

    public void add(CardType cardType, String key, Map<String, FieldType> entries) throws JSONException {
        this.cards.put(key, new CardEntry(cardType, key, entries));
    }

    @Override
    public long getLength(String name) {
        return this.lengths.get(name);
    }

    public void setLength(String name, long length) {
        this.lengths.put(name, length);
    }

    public boolean has(String cardName) {
        return this.cards.containsKey(cardName);
    }

    @Override
    public Iterator<String> iterator() {
        return this.cards.keySet().iterator();
    }

    public String toString() {
        return this.cards.keySet().toString();
    }
}

