/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.splitter;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.codehaus.jettison.json.JSONException;
import org.ziniki.splitter.CardData;
import org.ziniki.splitter.CardType;
import org.ziniki.splitter.FieldType;
import org.ziniki.splitter.MetaEntry;
import org.ziniki.splitter.NoMetaKeyException;

public class CardEntry
implements CardData {
    private final CardType type;
    private final String card;
    private final Map<String, FieldType> entries = new TreeMap<String, FieldType>();

    public CardEntry(CardType type, String card, Map<String, FieldType> entries) throws JSONException {
        this.type = type;
        this.card = card;
        this.entries.putAll(entries);
    }

    @Override
    public CardType type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.card;
    }

    @Override
    public String id() {
        return this.type.name().toLowerCase() + "s/" + this.card;
    }

    @Override
    public Iterator<MetaEntry> iterator() {
        final Iterator<Map.Entry<String, FieldType>> it = this.entries.entrySet().iterator();
        return new Iterator<MetaEntry>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public MetaEntry next() {
                final Map.Entry nx = (Map.Entry)it.next();
                return new MetaEntry(){

                    @Override
                    public String key() {
                        return (String)nx.getKey();
                    }

                    @Override
                    public FieldType value() {
                        return (FieldType)((Object)nx.getValue());
                    }
                };
            }
        };
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public boolean hasField(String slot) {
        return this.entries.containsKey(slot);
    }

    @Override
    public FieldType get(String key) {
        if (!this.entries.containsKey(key)) {
            throw new NoMetaKeyException(this.card, key);
        }
        return this.entries.get(key);
    }
}

