/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.jvm.ziniki;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import org.flasck.jvm.ziniki.ContentObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zinutils.exceptions.NotImplementedException;

public class MemoryContentObject
implements ContentObject {
    protected static final Logger logger = LoggerFactory.getLogger((String)"main");
    private String key;
    private byte[] bs;

    public MemoryContentObject(File f, byte[] bs) {
        this.key = f.getName();
        this.bs = bs;
    }

    public MemoryContentObject(String key, byte[] bs) {
        this.key = key;
        this.bs = bs;
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    public String url() {
        return "memory://" + this.key;
    }

    @Override
    public long length() {
        return this.bs.length;
    }

    @Override
    public String writeUrl() {
        throw new NotImplementedException();
    }

    @Override
    public String asString() {
        String ret = new String(this.bs);
        return ret;
    }

    @Override
    public byte[] asByteArray() {
        return this.bs;
    }

    @Override
    public InputStream asStream() {
        return new ByteArrayInputStream(this.bs);
    }

    public String toString() {
        return "MCO[" + this.key + "]";
    }
}

