/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.jvm.ziniki;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.flasck.jvm.ziniki.ContentObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zinutils.exceptions.CantHappenException;
import org.zinutils.exceptions.NotImplementedException;
import org.zinutils.exceptions.WrappedException;
import org.zinutils.utils.FileUtils;

public class FileContentObject
implements ContentObject {
    protected static final Logger logger = LoggerFactory.getLogger((String)"main");
    private File file;

    public FileContentObject(File f) {
        if (!f.canRead()) {
            throw new CantHappenException("cannot read file-as-CO: " + f);
        }
        this.file = f;
    }

    @Override
    public String key() {
        return this.file.getName();
    }

    @Override
    public String url() {
        return "file://" + this.file.getPath().replace(" ", "%20");
    }

    @Override
    public long length() {
        return this.file.length();
    }

    @Override
    public String writeUrl() {
        throw new NotImplementedException();
    }

    @Override
    public String asString() {
        return FileUtils.readFile((File)this.file);
    }

    @Override
    public byte[] asByteArray() {
        throw new NotImplementedException();
    }

    @Override
    public InputStream asStream() {
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            throw WrappedException.wrap((Throwable)e);
        }
    }

    public String toString() {
        return "FCO[" + this.file + "]";
    }
}

