/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.jvm.fl;

import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeoutException;
import org.flasck.jvm.FLEvalContext;
import org.flasck.jvm.builtin.FLError;
import org.flasck.jvm.builtin.Send;
import org.flasck.jvm.container.CardContext;
import org.flasck.jvm.container.CardEnvironment;
import org.flasck.jvm.container.ContractHolder;
import org.flasck.jvm.container.ContractRetriever;
import org.flasck.jvm.container.ExpectationException;
import org.flasck.jvm.container.FLASBroker;
import org.flasck.jvm.container.FLCard;
import org.flasck.jvm.container.FLEvalContextFactory;
import org.flasck.jvm.container.FLObject;
import org.flasck.jvm.container.JvmDispatcher;
import org.flasck.jvm.container.MockAgent;
import org.flasck.jvm.container.MockCard;
import org.flasck.jvm.container.MockService;
import org.flasck.jvm.container.RenderTree;
import org.flasck.jvm.container.ResponseWithMessages;
import org.flasck.jvm.container.UnexpectedCancelException;
import org.flasck.jvm.container.UpdatesDisplay;
import org.flasck.jvm.fl.AssertFailed;
import org.flasck.jvm.fl.ClientContext;
import org.flasck.jvm.fl.ClientEnvironment;
import org.flasck.jvm.fl.EventZone;
import org.flasck.jvm.fl.FlasTestException;
import org.flasck.jvm.fl.HandlerBase;
import org.flasck.jvm.fl.HandlerInfo;
import org.flasck.jvm.fl.InterestedInBroker;
import org.flasck.jvm.fl.JVMTestPlugin;
import org.flasck.jvm.fl.MockFLObject;
import org.flasck.jvm.fl.NewDivException;
import org.flasck.jvm.fl.NoFLASModule;
import org.flasck.jvm.fl.NotMatched;
import org.flasck.jvm.fl.TestHelper;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.ziniki.ziwsh.intf.EvalContext;
import org.ziniki.ziwsh.intf.EvalContextFactory;
import org.ziniki.ziwsh.intf.FieldsContainerWrapper;
import org.ziniki.ziwsh.intf.NamedIdempotentHandler;
import org.ziniki.ziwsh.jvm.ObjectMarshaller;
import org.zinutils.bytecode.BCEClassLoader;
import org.zinutils.exceptions.CantHappenException;
import org.zinutils.exceptions.NotImplementedException;
import org.zinutils.exceptions.WrappedException;
import org.zinutils.reflection.Reflection;
import org.zinutils.sync.LockingCounter;

public class JVMTestHelper
extends ClientEnvironment
implements TestHelper,
EvalContextFactory,
FLEvalContextFactory,
CardEnvironment,
UpdatesDisplay {
    private final File rootdir;
    private final List<Throwable> runtimeErrors;
    private final LockingCounter counter;
    private int docSince = 1;
    private final Map<Object, Object> mocks = new HashMap<Object, Object>();
    private final List<Object> activeSubscribers = new ArrayList<Object>();
    private final Map<String, Object> modules = new HashMap<String, Object>();
    private final List<Object> toCancel = new ArrayList<Object>();
    private final Iterable<JVMTestPlugin> plugins = ServiceLoader.load(JVMTestPlugin.class);

    public JVMTestHelper(ClassLoader loader, File rootdir, Map<String, String> templates, List<Throwable> runtimeErrors, LockingCounter counter) {
        super(true, loader, new JvmDispatcher("helper", 60000), templates);
        this.rootdir = rootdir;
        this.runtimeErrors = runtimeErrors;
        this.counter = counter;
        this.broker = new FLASBroker(this, loader);
        for (JVMTestPlugin p : this.plugins) {
            p.ready(this, loader);
        }
        if (loader instanceof BCEClassLoader) {
            for (JVMTestPlugin p : ((BCEClassLoader)loader).services(JVMTestPlugin.class)) {
                p.ready(this, loader);
            }
        }
    }

    public void reset() {
        this.runtimeErrors.clear();
    }

    @Override
    public ClassLoader loader() {
        return this.loader;
    }

    @Override
    public void register(String ctr, String impl) {
        try {
            Class<?> cc = Class.forName(ctr, false, this.loader);
            Class<?> ci = Class.forName(impl, false, this.loader);
            Object svc = ci.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (svc instanceof InterestedInBroker) {
                ((InterestedInBroker)svc).broker(this.broker);
            }
            this.broker.register(cc, svc);
        }
        catch (ClassNotFoundException ex) {
            logger.info("could not find " + ex.getMessage());
        }
        catch (Exception ex) {
            throw WrappedException.wrap((Throwable)ex);
        }
    }

    @Override
    public EvalContext newContext() {
        return this.create();
    }

    @Override
    public FLEvalContext create() {
        ClientContext ret = new ClientContext(this){

            @Override
            public Set<UpdatesDisplay> leaveEventLoop() {
                Set<UpdatesDisplay> ret = super.leaveEventLoop();
                return ret;
            }
        };
        return ret;
    }

    @Override
    public LockingCounter getTestCounter() {
        return this.counter;
    }

    @Override
    public MockAgent mockAgent(FLEvalContext cxt, ContractHolder agent) {
        MockAgent ret = new MockAgent(cxt, agent);
        return ret;
    }

    @Override
    public MockCard mockCard(FLEvalContext cxt, FLCard card) {
        MockCard ret = new MockCard(cxt, card);
        this.addCard(ret);
        return ret;
    }

    @Override
    public Object storeMock(FLEvalContext cxt, Object mock) throws TimeoutException {
        if ((mock = cxt.full(mock)) instanceof ResponseWithMessages) {
            this.dispatcher.queueMessages(cxt, ResponseWithMessages.messages(cxt, mock));
            this.dispatcher.waitForQueueDone();
            mock = ResponseWithMessages.response(cxt, mock);
        }
        if (mock instanceof FLObject) {
            FLObject flo = (FLObject)mock;
            MockFLObject mo = new MockFLObject(flo);
            this.mocks.put(flo, mo);
            this.addCard(mo);
        }
        return mock;
    }

    @Override
    protected UpdatesDisplay resolve(UpdatesDisplay card) {
        if (card instanceof FLObject) {
            return (UpdatesDisplay)this.mocks.get(card);
        }
        return super.resolve(card);
    }

    @Override
    public boolean hasMock(Object mc) {
        return this.mocks.containsKey(mc);
    }

    @Override
    public Object mock(Object mc) {
        return this.mocks.get(mc);
    }

    @Override
    public void error(Throwable error) {
        this.runtimeErrors.add(error);
    }

    @Override
    public void clearBody(FLEvalContext cx) {
        this.setDocument(Document.createShell((String)"http://localhost"));
    }

    @Override
    public void expectCancel(Object handler) {
        if (handler instanceof NamedIdempotentHandler) {
            String ihid = ((NamedIdempotentHandler)handler).ihid();
            this.toCancel.add(ihid);
        } else {
            if (!Proxy.isProxyClass(handler.getClass())) {
                throw new CantHappenException("not a valid proxy");
            }
            InvocationHandler ih = Proxy.getInvocationHandler(handler);
            if (!(ih instanceof ObjectMarshaller.BrokerIdemInvoker)) {
                throw new CantHappenException("not a valid invoker");
            }
            this.toCancel.add(((ObjectMarshaller.BrokerIdemInvoker)ih).handler());
        }
    }

    @Override
    public void assertSatisfied() {
        if (!this.toCancel.isEmpty()) {
            throw new ExpectationException("subscription of type " + this.toCancel.get(0).getClass().getName() + " was not cancelled");
        }
    }

    @Override
    public void assertSameValue(FLEvalContext cx, Object expected, Object actual) throws FlasTestException {
        if ((expected = cx.full(expected)) instanceof ResponseWithMessages) {
            expected = ResponseWithMessages.response(cx, expected);
        }
        actual = cx.full(actual);
        if (expected instanceof Number && !(expected instanceof Double)) {
            expected = Double.valueOf(expected.toString());
        }
        if (actual instanceof Number && !(actual instanceof Double)) {
            actual = Double.valueOf(actual.toString());
        }
        if (!cx.compare(expected, actual)) {
            throw new AssertFailed(expected, actual);
        }
    }

    @Override
    public void assertIdentical(FLEvalContext cx, Object expected, Object actual) throws FlasTestException {
        if ((expected = cx.full(expected)) != (actual = cx.full(actual))) {
            throw new AssertFailed(expected, actual);
        }
    }

    @Override
    public void shove(FLEvalContext cx, Object dest, String slot, Object val) throws FlasTestException {
        dest = cx.full(dest);
        val = cx.full(val);
        if (dest instanceof MockCard) {
            dest = ((MockCard)dest).card();
        }
        ((FieldsContainerWrapper)dest).set(slot, val);
        if (dest instanceof FLCard) {
            ((FLCard)dest)._updateDisplay(cx, ((FLCard)dest)._renderTree);
        } else {
            ((CardContext)cx).updateAllCards();
        }
    }

    @Override
    public void close(FLEvalContext cx, Object dest) throws FlasTestException {
        if ((dest = cx.full(dest)) instanceof MockCard) {
            dest = ((MockCard)dest).card();
        }
        ((ContractRetriever)dest)._close(cx);
        ((CardContext)cx).updateAllCards();
    }

    @Override
    public void invoke(FLEvalContext cx, Object expr) throws Exception {
        if ((expr = cx.full(expr)) instanceof List && ((List)expr).size() == 1) {
            expr = ((List)expr).get(0);
        }
        if (!(expr instanceof Send)) {
            throw new CantHappenException("can only invoke a Send, not a " + expr.getClass());
        }
        Send se = (Send)expr;
        if (se.to instanceof NamedIdempotentHandler) {
            se.to = ((NamedIdempotentHandler)se.to).handler();
        }
        FLEvalContext tcx = cx.bindSubContext(se.to);
        tcx.getDispatcher().queueMessages(tcx, expr);
        tcx.getDispatcher().waitForQueueDone();
    }

    @Override
    public void send(FLEvalContext cx, Object to, Object contract, Object meth, Object args) {
        this.send(cx, to, (String)contract, (String)meth, this.unmockArgs(args));
    }

    private Object[] unmockArgs(Object args) {
        List inargs = (List)args;
        Object[] ret = new Object[inargs.size()];
        int i = 0;
        for (Object o : inargs) {
            if (o instanceof MockCard) {
                ret[i++] = ((MockCard)o).card();
                continue;
            }
            ret[i++] = o;
        }
        return ret;
    }

    @Override
    public void send(FLEvalContext cx, Object to, String contract, String meth, Object ... args) {
        Object reply;
        MockCard mc = null;
        FLEvalContext tcx = cx.bindSubContext(to);
        if (to instanceof MockAgent) {
            reply = ((MockAgent)to).sendTo(tcx, contract, meth, args);
        } else if (to instanceof MockService) {
            reply = ((MockService)to).sendTo(tcx, contract, meth, args);
        } else if (to instanceof MockCard) {
            mc = (MockCard)to;
            reply = mc.sendTo(tcx, contract, meth, args);
        } else if (to instanceof HandlerBase) {
            reply = Reflection.call((Object)to, (String)meth, (Object[])new Object[]{tcx, args});
        } else {
            throw new NotImplementedException("cannot handle " + to.getClass());
        }
        tcx.queueMessages(reply);
        try {
            tcx.waitForQueueDone();
        }
        catch (TimeoutException ex) {
            ex.printStackTrace();
        }
        if (mc != null) {
            mc.card()._updateDisplay(tcx, mc.card()._renderTree);
        }
    }

    @Override
    public void render(FLEvalContext cx, Object card, int fn, String template) throws Exception {
        CardContext ec = (CardContext)cx;
        UpdatesDisplay mc = (UpdatesDisplay)card;
        if (!this.mocks.containsKey(mc)) {
            throw new CantHappenException("there is no mock for " + mc);
        }
        MockFLObject flo = (MockFLObject)this.mocks.get(mc);
        flo.initRender(ec, fn, template);
    }

    @Override
    public void event(FLEvalContext cx, Object card, List<EventZone> zone, Object event) throws Exception {
        CardContext ec = (CardContext)cx;
        UpdatesDisplay mc = (UpdatesDisplay)card;
        if (this.mocks.containsKey(mc)) {
            mc = (UpdatesDisplay)this.mocks.get(mc);
        }
        mc._updateFromInputs();
        if (zone.isEmpty()) {
            if (mc._renderTree() == null) {
                ec.dispatchEvent(mc._containedIn(), event);
            } else {
                ec.dispatchEvent(mc._renderTree().id(), event);
            }
        } else {
            Element e = this.findDiv(cx, mc._renderTree(), zone, 0);
            if (e == null) {
                return;
            }
            ec.dispatchEvent(e.attr("id"), event);
        }
    }

    @Override
    public void input(FLEvalContext cx, Object card, List<EventZone> zone, Object inputText) throws Exception {
        Element e;
        CardContext ec = (CardContext)cx;
        UpdatesDisplay mc = (UpdatesDisplay)card;
        if (this.mocks.containsKey(mc)) {
            mc = (UpdatesDisplay)this.mocks.get(mc);
        }
        if ((e = this.findDiv(cx, mc._renderTree(), zone, 0)) == null) {
            return;
        }
        if ((inputText = cx.full(inputText)) instanceof FLError) {
            cx.log(inputText);
            return;
        }
        if (!e.tagName().equals("input") || !e.hasAttr("type") || !e.attr("type").equals("text") && !e.attr("type").equals("password")) {
            ec.log("can only set input text on input elements of type text or password");
            return;
        }
        e.attr("value", (String)inputText);
    }

    private Element findDiv(FLEvalContext cx, RenderTree rt, List<EventZone> zone, int pos) throws NotMatched {
        CardContext ec = (CardContext)cx;
        if (pos >= zone.size()) {
            return ec.element(rt.id());
        }
        EventZone ez = zone.get(pos);
        if (ez.type.equals("item")) {
            List<RenderTree> chn = rt.children();
            if (!(ez.name instanceof Integer)) {
                throw new CantHappenException("this should have been converted to an integer in the constructor");
            }
            int x = (Integer)ez.name;
            if (chn == null || chn.size() <= x) {
                throw new NotMatched(zone, "There is no child " + x + " of " + this.nameOf(zone, pos));
            }
            return this.findDiv(cx, chn.get(x), zone, pos + 1);
        }
        RenderTree inner = this.findSubThroughSingle(rt, (String)ez.name);
        if (inner == null) {
            throw new NotMatched(zone, "There is no element " + ez.name + " in " + this.nameOf(zone, pos));
        }
        return this.findDiv(cx, inner, zone, pos + 1);
    }

    private RenderTree findSubThroughSingle(RenderTree rt, String name) {
        do {
            RenderTree ret;
            if ((ret = rt.getSub(name)) == null) continue;
            return ret;
        } while ((rt = rt.getSub("single")) != null);
        return null;
    }

    private String nameOf(List<EventZone> zone, int pos) {
        if (pos == 0) {
            return "card";
        }
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < pos; ++i) {
            if (ret.length() > 0) {
                ret.append(".");
            }
            ret.append(zone.get((int)i).name);
        }
        return ret.toString();
    }

    @Override
    public void matchText(FLEvalContext cx, Object card, List<EventZone> zone, boolean contains, boolean fails, String matches) throws NotMatched {
        Element elt;
        UpdatesDisplay mc = (UpdatesDisplay)card;
        if (this.mocks.containsKey(mc)) {
            mc = (UpdatesDisplay)this.mocks.get(mc);
        }
        try {
            elt = this.getDiv(cx, mc, zone);
        }
        catch (NotMatched t) {
            if (fails) {
                return;
            }
            throw t;
        }
        String content = elt.text().trim().replace('\n', ' ').replaceAll(" +", " ");
        if (contains ? !content.contains(matches) : !content.equals(matches)) {
            throw new NotMatched(zone, matches, content);
        }
    }

    @Override
    public void matchStyle(FLEvalContext cx, Object card, List<EventZone> zone, boolean contains, String matches) throws NotMatched {
        UpdatesDisplay mc = (UpdatesDisplay)card;
        if (this.mocks.containsKey(mc)) {
            mc = (UpdatesDisplay)this.mocks.get(mc);
        }
        Element elt = this.getDiv(cx, mc, zone);
        String classList = elt.attr("class");
        Set<String> have = this.getSortedSet(classList);
        Set<String> want = this.getSortedSet(matches);
        boolean failed = false;
        for (String s : want) {
            if (have.contains(s)) continue;
            failed = true;
        }
        if (!contains) {
            failed |= have.size() != want.size();
        }
        if (failed) {
            throw new NotMatched(zone, String.join((CharSequence)" ", want), String.join((CharSequence)" ", have));
        }
    }

    @Override
    public void matchScroll(FLEvalContext cx, Object card, List<EventZone> zone, boolean contains, Double curr) throws NotMatched {
        UpdatesDisplay mc = (UpdatesDisplay)card;
        if (this.mocks.containsKey(mc)) {
            mc = (UpdatesDisplay)this.mocks.get(mc);
        }
        Element elt = this.getDiv(cx, mc, zone);
    }

    @Override
    public void matchImageUri(FLEvalContext cx, Object card, List<EventZone> zone, String matches) throws NotMatched {
        Element elt;
        UpdatesDisplay mc = (UpdatesDisplay)card;
        if (this.mocks.containsKey(mc)) {
            mc = (UpdatesDisplay)this.mocks.get(mc);
        }
        if (!"IMG".equalsIgnoreCase((elt = this.getDiv(cx, mc, zone)).tagName())) {
            throw new NotMatched(zone, "IMG", elt.tagName());
        }
        String src = elt.attr("src");
        if (!matches.equals(src)) {
            throw new NotMatched(zone, matches, src);
        }
    }

    @Override
    public void matchHref(FLEvalContext cx, Object card, List<EventZone> zone, String matches) throws NotMatched {
        Element elt;
        UpdatesDisplay mc = (UpdatesDisplay)card;
        if (this.mocks.containsKey(mc)) {
            mc = (UpdatesDisplay)this.mocks.get(mc);
        }
        if (!"A".equalsIgnoreCase((elt = this.getDiv(cx, mc, zone)).tagName())) {
            throw new NotMatched(zone, "A", elt.tagName());
        }
        String src = elt.attr("href");
        if (!matches.equals(src)) {
            throw new NotMatched(zone, matches, src);
        }
    }

    private Set<String> getSortedSet(String classList) {
        TreeSet<String> have = new TreeSet<String>();
        for (String s : classList.trim().split(" ")) {
            if (s == null) continue;
            have.add(s);
        }
        return have;
    }

    private Element getDiv(FLEvalContext cx, Object target, List<EventZone> zone) throws NotMatched {
        if (target == null || !(target instanceof UpdatesDisplay)) {
            throw new NotMatched(zone, "The card had no rendered content");
        }
        RenderTree rt = ((UpdatesDisplay)target)._renderTree();
        if (rt == null) {
            throw new NotMatched(zone, "The card had no rendered content");
        }
        return this.findDiv(cx, rt, zone, 0);
    }

    @Override
    public void testComplete() throws Throwable {
        if (!this.runtimeErrors.isEmpty()) {
            throw this.runtimeErrors.get(0);
        }
    }

    @Override
    public void newdiv(Integer cnt) throws NewDivException {
        if (cnt != null && this.docId - this.docSince != cnt) {
            throw new NewDivException(cnt, this.docId - this.docSince);
        }
        this.docSince = this.docId;
    }

    @Override
    public RenderTree _renderTree() {
        return null;
    }

    @Override
    public void _updateDisplay(FLEvalContext cxt, RenderTree rt) {
    }

    @Override
    public void _updateFromInputs() {
    }

    @Override
    public void _attachHandlers(CardContext ec, RenderTree sub, Element node, String templateName, String field, Integer option, Object source, List<Boolean> evconds) {
    }

    @Override
    public Map<String, List<HandlerInfo>> _eventHandlers() {
        throw new NotImplementedException();
    }

    @Override
    public String _containedIn() {
        return null;
    }

    @Override
    public List<Object> activeSubscribers() {
        return this.activeSubscribers;
    }

    @Override
    public void configureModule(String name, Class<?> clz) {
        try {
            this.modules.put(name, Reflection.callStatic(clz, (String)"createJVM", (Object[])new Object[]{this, this.rootdir}));
        }
        catch (IllegalArgumentException | SecurityException e) {
            throw WrappedException.wrap((Throwable)e);
        }
    }

    @Override
    public Object module(String name) {
        if (!this.modules.containsKey(name)) {
            throw new NoFLASModule(name);
        }
        return this.modules.get(name);
    }

    public void cancelBound(String varName, String handlerName) {
        logger.info("want to cancel " + handlerName + " from " + this.toCancel);
        if (this.toCancel.contains(handlerName)) {
            this.toCancel.remove(handlerName);
        } else {
            this.error(new UnexpectedCancelException("cancelled " + varName + " but it was not expected"));
        }
    }
}

