/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.jvm.fl;

import java.util.Map;
import java.util.TreeMap;
import org.flasck.jvm.FLEvalContext;
import org.ziniki.ziwsh.intf.EvalContext;
import org.ziniki.ziwsh.intf.FieldsContainer;
import org.ziniki.ziwsh.intf.FieldsContainerWrapper;

public class JVMFieldsContainer
implements FieldsContainer {
    private Map<String, Object> fields = new TreeMap<String, Object>();

    public int size() {
        return this.fields.size();
    }

    public void set(String fld, Object value) {
        if (fld == null) {
            throw new RuntimeException("field cannot be null");
        }
        if (value == null) {
            throw new RuntimeException("if you want to remove a value, use clear; don't set to null");
        }
        this.fields.put(fld, value);
    }

    public boolean has(String fld) {
        return this.fields.containsKey(fld);
    }

    public Object get(String fld) {
        return this.fields.get(fld);
    }

    public void clear(String fld) {
        this.fields.remove(fld);
    }

    public void all(FieldsContainerWrapper.FieldsTraverser traverser) {
        for (Map.Entry<String, Object> e : this.fields.entrySet()) {
            if (e.getKey().startsWith("_")) continue;
            traverser.field(e.getKey(), e.getValue());
        }
    }

    public void allPlus(FieldsContainerWrapper.FieldsTraverser traverser) {
        for (Map.Entry<String, Object> e : this.fields.entrySet()) {
            traverser.field(e.getKey(), e.getValue());
        }
    }

    public boolean equalTo(EvalContext cxt, FieldsContainer state) {
        Map<String, Object> other = ((JVMFieldsContainer)state).fields;
        if (this.fields.size() != other.size()) {
            return false;
        }
        for (Map.Entry<String, Object> e : this.fields.entrySet()) {
            if (!other.containsKey(e.getKey())) {
                return false;
            }
            if (((FLEvalContext)cxt).compare(e.getValue(), other.get(e.getKey()))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "Fields[" + this.fields.size() + "]";
    }
}

