/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.jvm.fl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.flasck.jvm.FLEvalContext;
import org.flasck.jvm.fl.Applicable;
import org.zinutils.exceptions.NotImplementedException;

public class FLCurry
implements Applicable {
    private final Object obj;
    private final Applicable fn;
    private final Object[] current;
    private final List<Integer> missing;
    public final int nfargs;

    public FLCurry(Object obj, Applicable fn, int reqd, Map<Integer, Object> args) {
        this.obj = obj;
        this.fn = fn;
        this.missing = new ArrayList<Integer>();
        this.current = new Object[reqd];
        for (int i = 1; i <= reqd; ++i) {
            if (args.containsKey(i)) {
                this.current[i - 1] = args.get(i);
                continue;
            }
            this.missing.add(i);
        }
        this.nfargs = this.missing.size();
    }

    private FLCurry(Object obj, Applicable fn, List<Integer> missing, Object[] args) {
        this.obj = obj;
        this.fn = fn;
        if (!(fn instanceof Applicable)) {
            throw new NotImplementedException();
        }
        this.missing = missing;
        this.current = args;
        this.nfargs = missing.size();
    }

    public static FLCurry simple(Applicable operator, int reqd, Object[] provided) {
        Object[] args = new Object[reqd];
        ArrayList<Integer> missing = new ArrayList<Integer>();
        for (int i = 0; i < reqd; ++i) {
            if (i < provided.length) {
                args[i] = provided[i];
                continue;
            }
            missing.add(i);
        }
        return new FLCurry(null, operator, missing, args);
    }

    public static FLCurry object(Object on, Applicable operator, int reqd, Object[] provided) {
        Object[] args = new Object[reqd];
        ArrayList<Integer> missing = new ArrayList<Integer>();
        for (int i = 0; i < reqd; ++i) {
            if (i < provided.length) {
                args[i] = provided[i];
                continue;
            }
            missing.add(i);
        }
        return new FLCurry(on, operator, missing, args);
    }

    public static FLCurry explicit(Applicable op, int reqd, Object[] xcs) {
        int i;
        Object[] args = new Object[reqd];
        ArrayList<Integer> missing = new ArrayList<Integer>();
        for (i = 0; i < reqd; ++i) {
            missing.add(i);
        }
        for (i = 0; i < xcs.length; i += 2) {
            int k = (Integer)xcs[i];
            missing.remove((Object)k);
            args[k] = xcs[i + 1];
        }
        return new FLCurry(null, op, missing, args);
    }

    @Override
    public int nfargs() {
        return this.nfargs;
    }

    @Override
    public Object apply(FLEvalContext cx, Object obj, Object[] args) throws Throwable {
        ArrayList<Integer> missing = new ArrayList<Integer>(this.missing);
        Object[] merged = Arrays.copyOf(this.current, this.current.length);
        for (Object o : args) {
            int k = (Integer)missing.remove(0);
            merged[k] = o;
        }
        if (missing.isEmpty()) {
            return this.fn.apply(cx, cx.full(this.obj), merged);
        }
        return new FLCurry(this.obj, this.fn, missing, merged);
    }

    public Object arity() {
        return this.missing.size();
    }

    public String toString() {
        return "FLCurry[" + this.missing.size() + "]";
    }
}

