/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.jvm.fl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import org.flasck.jvm.FLEvalContext;
import org.flasck.jvm.builtin.Event;
import org.flasck.jvm.builtin.FLError;
import org.flasck.jvm.builtin.HashPair;
import org.flasck.jvm.builtin.MakeSend;
import org.flasck.jvm.builtin.Send;
import org.flasck.jvm.builtin.UpdateDisplay;
import org.flasck.jvm.container.CardContext;
import org.flasck.jvm.container.ContractHolder;
import org.flasck.jvm.container.Dispatcher;
import org.flasck.jvm.container.FLCard;
import org.flasck.jvm.container.FLEnvironment;
import org.flasck.jvm.container.MockAgent;
import org.flasck.jvm.container.MockCard;
import org.flasck.jvm.container.MockContract;
import org.flasck.jvm.container.MockService;
import org.flasck.jvm.container.ResponseWithMessages;
import org.flasck.jvm.container.UpdatesDisplay;
import org.flasck.jvm.fl.Applicable;
import org.flasck.jvm.fl.CallMethod;
import org.flasck.jvm.fl.Expecting;
import org.flasck.jvm.fl.FLClosure;
import org.flasck.jvm.fl.FLComparable;
import org.flasck.jvm.fl.FLCurry;
import org.flasck.jvm.fl.FLFullEval;
import org.flasck.jvm.fl.JVMFieldsContainer;
import org.flasck.jvm.fl.JVMFieldsContainerWrapper;
import org.flasck.jvm.fl.TestHelper;
import org.flasck.jvm.fl.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.ziwsh.intf.EvalContext;
import org.ziniki.ziwsh.intf.FieldsContainer;
import org.ziniki.ziwsh.intf.FieldsContainerWrapper;
import org.ziniki.ziwsh.intf.IdempotentHandler;
import org.ziniki.ziwsh.intf.NamedIdempotentHandler;
import org.ziniki.ziwsh.intf.ObjectMarshalling;
import org.ziniki.ziwsh.intf.Wireable;
import org.ziniki.ziwsh.intf.ZiwshBroker;
import org.ziniki.ziwsh.jvm.AreYouA;
import org.ziniki.ziwsh.jvm.LoggingIdempotentHandler;
import org.zinutils.exceptions.CantHappenException;
import org.zinutils.exceptions.HaventConsideredThisException;
import org.zinutils.exceptions.NotImplementedException;
import org.zinutils.reflection.Reflection;

public abstract class FLCommonEvalContext
implements FLEvalContext {
    public final Logger logger = LoggerFactory.getLogger((String)this.getClass().getSimpleName());
    public static Logger debuglogger = LoggerFactory.getLogger((String)"DebugLog");
    private List<FLError> errors = new ArrayList<FLError>();
    private ZiwshBroker broker;
    private Dispatcher dispatcher;
    protected FLEnvironment env;
    private HashSet<UpdatesDisplay> updates;
    private Object subscriptionContext;

    public FLCommonEvalContext(FLEnvironment env) {
        this.env = env;
        if (env != null) {
            this.broker = env.getBroker();
            this.dispatcher = env.getDispatcher();
        }
    }

    protected void bindContext(Object to) {
        this.subscriptionContext = to;
    }

    public boolean isMockContract(Object svc) {
        InvocationHandler handler;
        if (svc instanceof MockContract) {
            return true;
        }
        return Proxy.isProxyClass(svc.getClass()) && (handler = Proxy.getInvocationHandler(svc)) instanceof MockContract;
    }

    @Override
    public Object getSubscriptionContext() {
        return this.subscriptionContext;
    }

    @Override
    public void unsubscribeAll(ContractHolder card) {
        this.env.unsubscribeAll(this, card);
    }

    @Override
    public void close() throws InterruptedException {
        if (this.broker != null) {
            this.broker.close();
        }
        if (this.dispatcher != null) {
            this.dispatcher.close();
        }
    }

    public ZiwshBroker getBroker() {
        return this.broker;
    }

    @Override
    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    @Override
    public FLEnvironment getEnvironment() {
        return this.env;
    }

    public void bindNamedHandler(NamedIdempotentHandler nih) {
        this.env.bindNamedHandler(this, nih);
    }

    @Override
    public void addAll(List<Object> ret, Object add) {
        this.dispatcher.addAll(ret, add);
    }

    @Override
    public Object head(Object obj) {
        while (obj instanceof FLClosure) {
            obj = ((FLClosure)obj).eval(this);
        }
        return obj;
    }

    @Override
    public Object spine(Object object) {
        if ((object = this.head(object)) == null) {
            return new ArrayList();
        }
        if (object instanceof FLError) {
            return object;
        }
        if (object instanceof List) {
            return object;
        }
        if (object instanceof Map) {
            return object;
        }
        throw new CantHappenException("spine should only be called on things known to be lists");
    }

    @Override
    public Object full(Object value) {
        ArrayList<List<Object>> msgs = new ArrayList<List<Object>>();
        if ((value = this.head(value)) instanceof List) {
            List l = (List)value;
            for (int i = 0; i < l.size(); ++i) {
                Object tmp = this.full(l.get(i));
                if (tmp instanceof ResponseWithMessages) {
                    List<Object> m = ResponseWithMessages.messages(this, tmp);
                    msgs.add(0, m);
                    tmp = ResponseWithMessages.response(this, tmp);
                }
                l.set(i, tmp);
            }
        } else if (value instanceof FLFullEval) {
            ((FLFullEval)value)._fullEval(this);
        } else if (value instanceof FieldsContainerWrapper) {
            FieldsContainerWrapper fcw = (FieldsContainerWrapper)value;
            ArrayList toClear = new ArrayList();
            fcw.all((k, v) -> {
                Object full = this.full(v);
                if (full instanceof ResponseWithMessages) {
                    List<Object> m = ResponseWithMessages.messages(this, full);
                    msgs.add(0, m);
                    full = ResponseWithMessages.response(this, full);
                }
                if (full == null) {
                    toClear.add(k);
                } else {
                    fcw.set(k, full);
                }
            });
            for (String k2 : toClear) {
                fcw.clear(k2);
            }
        }
        if (msgs.isEmpty()) {
            return value;
        }
        return new ResponseWithMessages(this, value, msgs);
    }

    @Override
    public List<Object> array(Object ... args) {
        ArrayList<Object> ret = new ArrayList<Object>();
        for (Object o : args) {
            ret.add(o);
        }
        return ret;
    }

    @Override
    public Object hash(Object ... args) {
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        for (Object o : args) {
            if (!((o = this.head(o)) instanceof HashPair)) {
                return new FLError("not a hashpair");
            }
            HashPair hp = (HashPair)o;
            String m = (String)this.full(hp.m);
            ret.put(m, hp.o);
        }
        return ret;
    }

    @Override
    public Object applyhash(Object basic, Object hash) {
        if ((basic = this.head(basic)) instanceof FLError) {
            return basic;
        }
        if ((hash = this.spine(hash)) instanceof FLError) {
            return hash;
        }
        FieldsContainerWrapper fc = (FieldsContainerWrapper)basic;
        Map m = (Map)hash;
        for (Map.Entry e : m.entrySet()) {
            if (!fc.has((String)e.getKey())) {
                return new FLError("cannot override member: " + (String)e.getKey());
            }
            fc.set((String)e.getKey(), e.getValue());
        }
        return basic;
    }

    @Override
    public Object mksend(String meth, Object on, int curry, Object handler, Object subscriptionName) {
        if (curry == 0) {
            return Send.eval(this, on, meth, new ArrayList(), handler, subscriptionName);
        }
        return MakeSend.dot(meth, on, curry, handler, subscriptionName);
    }

    @Override
    public Object mkacor(Class<?> obj, String meth, Object on, int curry) {
        if (on == null) {
            return null;
        }
        Method method = null;
        for (Method m : obj.getMethods()) {
            if (!m.getName().equals(meth) || method != null && !m.getDeclaringClass().equals(obj)) continue;
            method = m;
        }
        if (method == null) {
            return new FLError("there is no method " + meth + " on " + obj.getName());
        }
        if (curry == 0) {
            return FLClosure.object(on, new CallMethod(method, curry), new Object[0]);
        }
        return FLCurry.object(on, new CallMethod(method, curry), curry, new Object[0]);
    }

    @Override
    public Object makeTuple(Object ... args) {
        return new Tuple(args);
    }

    @Override
    public Object tupleMember(Object tuple, int which) {
        tuple = this.head(tuple);
        return ((Tuple)tuple).member(which);
    }

    @Override
    public void handleEvent(FLCard card, Method handler, Event event) {
        try {
            Object reply = handler.invoke((Object)card, this, new Object[]{event});
            UpdateDisplay ud = new UpdateDisplay(this, card);
            if (reply == null) {
                reply = ud;
            } else if (reply instanceof List) {
                ((List)reply).add(ud);
            } else {
                throw new HaventConsideredThisException("return was " + reply.getClass());
            }
            this.queueMessages(reply);
            this.dispatcher.waitForQueueDone();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void waitForQueueDone() throws TimeoutException {
        this.dispatcher.waitForQueueDone();
    }

    @Override
    public void queueMessages(Object msgs) {
        msgs = this.full(msgs);
        this.dispatcher.queueMessages(this, msgs);
    }

    @Override
    public void handleMessages(Object msgs) {
        msgs = this.full(msgs);
        this.enterEventLoop();
        this.dispatcher.handleMessages(this, msgs);
        this.leaveEventLoop();
    }

    @Override
    public FieldsContainer newFieldsContainer() {
        return new JVMFieldsContainer();
    }

    @Override
    public Object field(Object from, String field) {
        Object a0 = this.full(from);
        if (a0 == null) {
            return null;
        }
        if (a0 instanceof List) {
            List l = (List)a0;
            switch (field) {
                case "head": {
                    return l.get(0);
                }
                case "tail": {
                    return l.subList(1, l.size());
                }
            }
            throw new RuntimeException("No field '" + field + "'");
        }
        throw new NotImplementedException();
    }

    @Override
    public boolean isConst(Object obj, int val) {
        if (!(obj instanceof Double)) {
            return false;
        }
        double n = (Double)obj;
        return n == (double)val;
    }

    @Override
    public boolean isConst(Object obj, String val) {
        if (!(obj instanceof String)) {
            return false;
        }
        return val.equals(obj);
    }

    @Override
    public boolean compare(Object lhs, Object rhs) {
        lhs = this.full(lhs);
        rhs = this.full(rhs);
        if (lhs instanceof String) {
            return lhs.equals(rhs);
        }
        if (lhs instanceof Double) {
            if (!(rhs instanceof Double)) {
                return false;
            }
            return ((Double)lhs).doubleValue() == ((Double)rhs).doubleValue();
        }
        if (lhs instanceof Object[] && rhs instanceof Object[]) {
            Object[] la = (Object[])lhs;
            Object[] ra = (Object[])rhs;
            if (la.length != ra.length) {
                return false;
            }
            for (int i = 0; i < la.length; ++i) {
                if (this.compare(la[i], ra[i])) continue;
                return false;
            }
            return true;
        }
        if (lhs instanceof Collection && rhs instanceof Collection) {
            Collection la = (Collection)lhs;
            Collection ra = (Collection)rhs;
            if (la.size() != ra.size()) {
                return false;
            }
            Iterator ri = ra.iterator();
            for (Object lo : la) {
                Object ro;
                if (this.compare(lo, ro = ri.next())) continue;
                return false;
            }
            return true;
        }
        if (lhs instanceof FLComparable) {
            try {
                return ((FLComparable)lhs).equalTo(this, rhs);
            }
            catch (ClassCastException ex) {
                return false;
            }
        }
        if (lhs instanceof FieldsContainerWrapper) {
            if (!(rhs instanceof FieldsContainerWrapper)) {
                return false;
            }
            JVMFieldsContainerWrapper lf = (JVMFieldsContainerWrapper)lhs;
            return lf.equalTo(this, (JVMFieldsContainerWrapper)rhs);
        }
        if (lhs == rhs) {
            return true;
        }
        if (lhs != null) {
            return lhs.equals(rhs);
        }
        return false;
    }

    @Override
    public Object error(String msg) {
        FLError ret = new FLError(msg);
        this.errors.add(ret);
        return ret;
    }

    @Override
    public Throwable getError() {
        if (this.errors.isEmpty()) {
            return null;
        }
        return this.errors.get(0);
    }

    @Override
    public FLClosure closure(Applicable fn, Object ... args) {
        return FLClosure.simple(fn, args);
    }

    @Override
    public FLClosure oclosure(Applicable fn, Object ... args) {
        return FLClosure.object(args[0], fn, Arrays.copyOfRange(args, 1, args.length));
    }

    @Override
    public FLCurry curry(int reqd, Applicable op, Object ... args) {
        return FLCurry.simple(op, reqd, args);
    }

    @Override
    public FLCurry ocurry(int reqd, Applicable op, Object ... args) {
        return FLCurry.object(args[0], op, reqd, Arrays.copyOfRange(args, 1, args.length));
    }

    @Override
    public FLCurry xcurry(int reqd, Applicable op, Object ... xcs) {
        return FLCurry.explicit(op, reqd, xcs);
    }

    @Override
    public boolean isA(Object obj, String type) {
        obj = this.head(obj);
        if ("Any".equals(type)) {
            return true;
        }
        if (obj instanceof Double && "Number".equals(type)) {
            return true;
        }
        if (obj instanceof String && "String".equals(type)) {
            return true;
        }
        if (obj instanceof List) {
            if ("List".equals(type)) {
                return true;
            }
            List l = (List)obj;
            if (l.isEmpty() && "Nil".equals(type)) {
                return true;
            }
            if (!l.isEmpty() && "Cons".equals(type)) {
                return true;
            }
        } else if (obj instanceof Boolean) {
            if ("Boolean".equals(type)) {
                return true;
            }
            Boolean b = (Boolean)obj;
            if (b.booleanValue() && "True".equals(type)) {
                return true;
            }
            if (!b.booleanValue() && "False".equals(type)) {
                return true;
            }
        } else if (obj instanceof AreYouA) {
            return ((AreYouA)obj)._areYouA((EvalContext)this, type);
        }
        return false;
    }

    @Override
    public boolean isTruthy(Object clos) {
        if ((clos = this.full(clos)) instanceof Boolean) {
            return (Boolean)clos;
        }
        return false;
    }

    @Override
    public Object getSingleton(String name) {
        return this.env.getSingleton(name);
    }

    @Override
    public void cacheSingleton(String name, Object value) {
        this.env.cacheSingleton(name, value);
    }

    @Override
    public <T> T mockContract(CardContext collector, Class<T> ctr) {
        Class[] interfaces = new Class[]{ctr, AreYouA.class, Expecting.class};
        Object ret = Proxy.newProxyInstance(this.getLoader(), interfaces, (InvocationHandler)new MockContract(collector, ctr));
        this.getBroker().register(ctr, ret);
        return (T)ret;
    }

    @Override
    public MockAgent mockAgent(ContractHolder agent) {
        return ((TestHelper)((Object)this.env)).mockAgent(this, agent);
    }

    @Override
    public MockCard mockCard(FLCard card) {
        return ((TestHelper)((Object)this.env)).mockCard(this, card);
    }

    @Override
    public MockService mockService(ContractHolder agent) {
        return new MockService(agent);
    }

    public ClassLoader getLoader() {
        return this.env.getLoader();
    }

    @Override
    public void log(Object value) {
        if (value == null) {
            debuglogger.info("null");
        } else {
            debuglogger.info(value.toString());
        }
    }

    public IdempotentHandler trivialHandler() {
        return new LoggingIdempotentHandler();
    }

    @Override
    public Object storeMock(Object mock) throws TimeoutException {
        return ((TestHelper)((Object)this.env)).storeMock(this, mock);
    }

    @Override
    public void enterEventLoop() {
        if (this.updates != null) {
            throw new CantHappenException("recursive event loop");
        }
        this.updates = new HashSet();
        this.logger.debug("entering event loop with " + this.updates);
    }

    @Override
    public void needsUpdate(UpdatesDisplay target) {
        this.logger.debug("needsUpdate called");
        if (this.updates == null) {
            throw new CantHappenException("needsUpdate was called outside the event loop");
        }
        this.updates.add(target);
    }

    @Override
    public Set<UpdatesDisplay> leaveEventLoop() {
        if (this.updates == null) {
            throw new CantHappenException("not in event loop");
        }
        HashSet<UpdatesDisplay> ret = this.updates;
        this.logger.debug("leaving event loop; returning " + this.updates);
        this.updates = null;
        return ret;
    }

    public Wireable fromWire(ClassLoader classLoader, ObjectMarshalling om, Map<String, Object> m) {
        return (Wireable)Reflection.callStatic((ClassLoader)classLoader, (String)((String)m.get("_wireable")), (String)"fromWire", (Object[])new Object[]{this, om, m});
    }

    @Override
    public abstract FLEvalContext bindSubContext(Object var1);
}

