/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.jvm.fl;

import java.util.Arrays;
import org.flasck.jvm.FLEvalContext;
import org.flasck.jvm.builtin.FLError;
import org.flasck.jvm.container.ResponseWithMessages;
import org.flasck.jvm.fl.Applicable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zinutils.exceptions.UtilException;
import org.zinutils.exceptions.WrappedException;

public class FLClosure
implements Applicable {
    public static final Logger logger = LoggerFactory.getLogger((String)"FlasckLib");
    private Object eval;
    private Object obj;
    private final Applicable fn;
    private final Object[] args;

    private FLClosure(Object obj, Applicable fn, Object ... args) {
        this.obj = obj;
        this.fn = fn;
        this.args = args;
    }

    public static FLClosure simple(Applicable fn, Object ... args) {
        return new FLClosure(null, fn, args);
    }

    public static FLClosure object(Object obj, Applicable fn, Object ... args) {
        return new FLClosure(obj, fn, args);
    }

    @Override
    public int nfargs() {
        return 0;
    }

    public Object eval(FLEvalContext cx) {
        if (this.eval != null) {
            return this.eval;
        }
        try {
            Object foo;
            this.obj = foo = cx.full(this.obj);
            if (this.obj instanceof FLError) {
                this.eval = this.obj;
                return this.obj;
            }
            if (this.fn instanceof FLError) {
                this.eval = this.fn;
                return this.eval;
            }
            int wanted = this.fn.nfargs();
            if (this.args.length > wanted) {
                Object[] pass = Arrays.copyOf(this.args, wanted);
                this.eval = this.fn.apply(cx, this.obj, pass);
                if (this.eval instanceof FLError) {
                    return this.eval;
                }
                this.eval = new FLClosure(this.obj, (Applicable)this.eval, Arrays.copyOfRange(this.args, wanted, this.args.length));
                return this.eval;
            }
            Object ret = this.eval = this.fn.apply(cx, this.obj, this.args);
            if (this.eval instanceof ResponseWithMessages) {
                ResponseWithMessages rwm = (ResponseWithMessages)this.eval;
                this.eval = ResponseWithMessages.response(cx, rwm);
            }
            return ret;
        }
        catch (Throwable t) {
            t = WrappedException.unwrapThrowable((Throwable)t);
            logger.error("encountered exception", t);
            throw UtilException.wrap((Throwable)t);
        }
    }

    @Override
    public Object apply(FLEvalContext cx, Object obj, Object[] args) throws Throwable {
        return this.eval(cx);
    }

    public String toString() {
        return "FLClosure[]";
    }
}

