/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.jvm.fl;

import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.flasck.jvm.FLEvalContext;
import org.flasck.jvm.container.Dispatcher;
import org.flasck.jvm.container.FLASBroker;
import org.flasck.jvm.container.FLEnvironment;
import org.ziniki.ziwsh.intf.EvalContext;
import org.ziniki.ziwsh.intf.EvalContextFactory;
import org.ziniki.ziwsh.intf.NamedIdempotentHandler;
import org.ziniki.ziwsh.intf.ZiwshBroker;
import org.zinutils.collections.ListMap;
import org.zinutils.collections.MapMap;
import org.zinutils.exceptions.HaventConsideredThisException;
import org.zinutils.graphs.DirectedAcyclicGraph;

public abstract class CommonEnvironment
implements FLEnvironment,
EvalContextFactory {
    protected ClassLoader loader;
    protected ZiwshBroker broker;
    protected Dispatcher dispatcher;
    private final MapMap<Object, String, NamedIdempotentHandler> namedSubscriptions = new MapMap();
    private final ListMap<Object, NamedIdempotentHandler> unnamedSubscriptions = new ListMap();
    private final DirectedAcyclicGraph<Object> subDag = new DirectedAcyclicGraph();
    private final Map<String, Object> singletons = new TreeMap<String, Object>();

    protected CommonEnvironment() {
    }

    protected CommonEnvironment(boolean createBroker, ClassLoader loader, Dispatcher dispatcher) {
        this.loader = loader;
        if (createBroker) {
            this.broker = new FLASBroker(this, loader);
        }
        this.dispatcher = dispatcher;
    }

    @Override
    public ClassLoader getLoader() {
        return this.loader;
    }

    @Override
    public void provideBroker(ZiwshBroker broker) {
        this.broker = broker;
    }

    @Override
    public ZiwshBroker getBroker() {
        return this.broker;
    }

    @Override
    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    @Override
    public void bindNamedHandler(FLEvalContext cx, NamedIdempotentHandler nih) {
        Object subCx = cx.getSubscriptionContext();
        if (subCx == null) {
            throw new HaventConsideredThisException("sub context not bound");
        }
        if (nih.handler() != null) {
            this.subDag.ensure(subCx);
            this.subDag.ensure((Object)nih.handler());
            this.subDag.link(subCx, (Object)nih.handler());
        }
        if (nih.name() == null) {
            this.unnamedSubscriptions.add(subCx, (Object)nih);
        } else {
            if (this.namedSubscriptions.contains(subCx, (Object)nih.name())) {
                NamedIdempotentHandler old = (NamedIdempotentHandler)this.namedSubscriptions.get(subCx, (Object)nih.name());
                Iterable nested = this.subDag.children((Object)old.handler());
                for (Object sc : nested) {
                    this.unsubscribeAll(cx, sc);
                }
                this.broker.cancel((EvalContext)cx, old.ihid());
            }
            this.namedSubscriptions.add(subCx, (Object)nih.name(), (Object)nih);
        }
    }

    @Override
    public void unsubscribeAll(FLEvalContext cx, Object subscCxt) {
        for (NamedIdempotentHandler x : this.unnamedSubscriptions.values()) {
            this.broker.cancel((EvalContext)cx, x.ihid());
        }
        Collection key2Set = this.namedSubscriptions.values();
        for (NamedIdempotentHandler x : key2Set) {
            this.broker.cancel((EvalContext)cx, x.ihid());
        }
        this.namedSubscriptions.clear();
    }

    @Override
    public Object getSingleton(String name) {
        return this.singletons.get(name);
    }

    @Override
    public void cacheSingleton(String name, Object value) {
        this.singletons.put(name, value);
    }
}

