/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.jvm.fl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeoutException;
import org.flasck.jvm.FLEvalContext;
import org.flasck.jvm.builtin.Event;
import org.flasck.jvm.container.CardContext;
import org.flasck.jvm.container.CardEnvironment;
import org.flasck.jvm.container.Dispatcher;
import org.flasck.jvm.container.FLEvalContextFactory;
import org.flasck.jvm.container.JvmDispatcher;
import org.flasck.jvm.container.UpdatesDisplay;
import org.flasck.jvm.fl.ClientContext;
import org.flasck.jvm.fl.CommonEnvironment;
import org.flasck.jvm.fl.HandlerInfo;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.ziwsh.intf.EvalContext;
import org.ziniki.ziwsh.intf.EvalContextFactory;
import org.zinutils.collections.ListMap;
import org.zinutils.exceptions.NotImplementedException;

public class ClientEnvironment
extends CommonEnvironment
implements CardEnvironment,
FLEvalContextFactory,
EvalContextFactory {
    public static final Logger logger = LoggerFactory.getLogger((String)"FlasckLib");
    private final Map<String, String> templates;
    protected int docId = 1;
    private Document document;
    private final List<UpdatesDisplay> cards = new ArrayList<UpdatesDisplay>();
    private ListMap<String, FireEvent> events = new ListMap();
    private int evid = 1;
    private FLEvalContextFactory creator;

    public ClientEnvironment() {
        this(true, ClientEnvironment.class.getClassLoader(), new JvmDispatcher("client", 500), new TreeMap<String, String>());
    }

    public ClientEnvironment(boolean createBroker) {
        this(createBroker, ClientEnvironment.class.getClassLoader(), new JvmDispatcher("client", 500), new TreeMap<String, String>());
        this.dispatcher = new JvmDispatcher("client", 500);
    }

    public ClientEnvironment(boolean createBroker, ClassLoader loader, Dispatcher dispatcher, Map<String, String> templates) {
        super(createBroker, loader, dispatcher);
        this.templates = templates;
    }

    public ClientEnvironment withCreator(FLEvalContextFactory creator) {
        this.creator = creator;
        return this;
    }

    @Override
    public void error(Throwable error) {
        logger.error("runtime error", error);
    }

    @Override
    public String getTemplate(String template) {
        return this.templates.get(template);
    }

    protected void setDocument(Document d) {
        this.document = d;
    }

    public Document document() {
        return this.document;
    }

    @Override
    public String nextDocumentId() {
        return "flaselt_" + this.docId++;
    }

    @Override
    public Element newdiv() {
        return this.document.createElement("div");
    }

    @Override
    public Element getElement(String id) {
        return this.document.getElementById(id);
    }

    @Override
    public void setTitle(String title) {
        Element head = this.document.head();
        Elements titles = head.getElementsByTag("title");
        if (titles.isEmpty()) {
            Element t = this.document.createElement("title");
            head.appendChild((Node)t);
            titles.add((Object)t);
        }
        ((Element)titles.get(0)).text(title);
    }

    @Override
    public void attachToBody(Element newdiv) {
        this.document.body().appendChild((Node)newdiv);
    }

    @Override
    public FLEvalContext create() {
        if (this.creator != null) {
            return this.creator.create();
        }
        return new ClientContext(this);
    }

    public EvalContext newContext() {
        if (this.creator != null) {
            return this.creator.create();
        }
        return new ClientContext(this);
    }

    @Override
    public FireEvent addEventToCard(UpdatesDisplay card, HandlerInfo hi, Element ldiv, Object source) {
        if (!ldiv.hasAttr("id")) {
            throw new NotImplementedException("target should have id");
        }
        String id = ldiv.attr("id");
        int id1 = this.evid++;
        FireEvent fe = new FireEvent(id1, card, hi.handler, hi.event, source);
        this.events.add((Object)id, (Object)fe);
        return fe;
    }

    @Override
    public void removeEventFromCard(Element ldiv, FireEvent fe) {
        if (!ldiv.hasAttr("id")) {
            throw new NotImplementedException("target should have id");
        }
        String id = ldiv.attr("id");
        this.events.remove((Object)id, (Object)fe);
    }

    @Override
    public void dispatchEvent(CardContext ec, String id, Object event) {
        while (true) {
            boolean fired = false;
            if (this.events.contains((Object)id)) {
                ArrayList l = new ArrayList(this.events.get((Object)id));
                for (FireEvent fe : l) {
                    if (!event.getClass().getSimpleName().equals(fe.eventClz)) continue;
                    try {
                        ((Event)event).sourceTrait(this.getElement(id), fe.source);
                        Object msgs = fe.handler.invoke((Object)fe.card, ec, new Object[]{event});
                        ec.queueMessages(msgs);
                        ec.waitForQueueDone();
                        UpdatesDisplay mo = this.resolve(fe.card);
                        mo._updateDisplay(ec, mo._renderTree());
                        fired = true;
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException | TimeoutException e) {
                        e.printStackTrace();
                        return;
                    }
                }
            }
            if (fired) {
                return;
            }
            Element elt = this.getElement(id);
            if (elt == null) {
                return;
            }
            do {
                if ((elt = elt.parent()) != null) continue;
                return;
            } while (!elt.hasAttr("id"));
            id = elt.attr("id");
        }
    }

    protected UpdatesDisplay resolve(UpdatesDisplay card) {
        return card;
    }

    protected void addCard(UpdatesDisplay ud) {
        this.cards.add(ud);
    }

    @Override
    public void updateAllCards(CardContext cx) {
        for (UpdatesDisplay c : this.cards) {
            c._updateDisplay(cx, c._renderTree());
        }
    }

    public static class FireEvent {
        private final String eventClz;
        private final UpdatesDisplay card;
        private final Method handler;
        private final Object source;

        public FireEvent(int id, UpdatesDisplay card, Method handler, String eventClz, Object source) {
            this.card = card;
            this.handler = handler;
            this.eventClz = eventClz;
            this.source = source;
        }
    }
}

