/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.jvm.fl;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.flasck.jvm.FLEvalContext;
import org.flasck.jvm.fl.Applicable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zinutils.exceptions.NotImplementedException;

public class CallStatic
implements Applicable {
    public static final Logger logger = LoggerFactory.getLogger((String)"FlasckLib");
    public static final Logger tracker = LoggerFactory.getLogger((String)"CallTracker");
    private final Method meth;
    private final int nfargs;

    public CallStatic(Class<?> clz, String method, int nfargs) {
        Method chosen = null;
        for (Method m : clz.getDeclaredMethods()) {
            if (!Modifier.isStatic(m.getModifiers()) || !m.getName().contentEquals(method)) continue;
            chosen = m;
            break;
        }
        if (chosen == null) {
            throw new NotImplementedException("There is no method " + method + " in " + clz);
        }
        this.meth = chosen;
        this.nfargs = nfargs;
    }

    @Override
    public int nfargs() {
        return this.nfargs;
    }

    @Override
    public Object apply(FLEvalContext cx, Object obj, Object[] args) throws Throwable {
        tracker.info("Invoking " + this.meth.getDeclaringClass().getName() + "." + this.meth.getName());
        return this.meth.invoke(this.meth.getDeclaringClass(), cx, args);
    }
}

