/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.jvm.fl;

import java.lang.reflect.Method;
import org.flasck.jvm.FLEvalContext;
import org.flasck.jvm.builtin.Cons;
import org.flasck.jvm.fl.Applicable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zinutils.exceptions.CantHappenException;

public class CallMethod
implements Applicable {
    public static final Logger logger = LoggerFactory.getLogger((String)"FlasckLib");
    public static final Logger tracker = LoggerFactory.getLogger((String)"CallTracker");
    private final Method meth;
    private final int nfargs;

    public CallMethod(Method method, int nfargs) {
        this.meth = method;
        this.nfargs = nfargs;
    }

    public CallMethod(Class<?> clz, String meth, int nfargs) {
        Method[] meths = clz.getDeclaredMethods();
        Method method = null;
        for (Method m : meths) {
            if (!m.getName().equals(meth)) continue;
            method = m;
        }
        if (method == null) {
            throw new CantHappenException("did not find a method " + meth + " in " + clz.getName());
        }
        this.meth = method;
        this.nfargs = nfargs;
    }

    @Override
    public int nfargs() {
        return this.nfargs;
    }

    @Override
    public Object apply(FLEvalContext cx, Object obj, Object[] args) throws Throwable {
        if ((obj = cx.full(obj)) == null) {
            return null;
        }
        tracker.debug(".> " + this.meth.getDeclaringClass().getName() + "." + this.meth.getName() + " with " + args.length + " args");
        if (this.meth.getDeclaringClass() == Cons.class) {
            return this.meth.invoke(Cons.wrap(obj), cx, args);
        }
        return this.meth.invoke(obj, cx, args);
    }
}

