/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.jvm.fl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.flasck.jvm.FLEvalContext;
import org.flasck.jvm.fl.Applicable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zinutils.exceptions.WrappedException;

public class CallEval
implements Applicable {
    public static final Logger logger = LoggerFactory.getLogger((String)"FlasckLib");
    public static final Logger tracker = LoggerFactory.getLogger((String)"CallTracker");
    private final Method meth;
    private final int nfargs;

    public CallEval(Class<?> cls) {
        try {
            Field fld = cls.getField("nfargs");
            this.nfargs = fld.getInt(cls);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            logger.error("Could not find nfargs in " + cls);
            throw WrappedException.wrap((Throwable)e);
        }
        try {
            this.meth = cls.getMethod("eval", FLEvalContext.class, Object[].class);
        }
        catch (NoSuchMethodException ex) {
            logger.error("Could not find eval method in " + cls);
            throw WrappedException.wrap((Throwable)ex);
        }
    }

    @Override
    public int nfargs() {
        return this.nfargs;
    }

    @Override
    public Object apply(FLEvalContext cx, Object obj, Object[] args) throws Throwable {
        tracker.info("*> " + this.meth.getDeclaringClass().getName() + " with " + args.length);
        return this.meth.invoke(null, cx, args);
    }
}

