/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.jvm.container;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.flasck.jvm.FLEvalContext;
import org.flasck.jvm.builtin.CroEntry;
import org.flasck.jvm.builtin.Crobag;
import org.flasck.jvm.builtin.Html;
import org.flasck.jvm.builtin.Image;
import org.flasck.jvm.builtin.Link;
import org.flasck.jvm.container.CardContext;
import org.flasck.jvm.container.FLCard;
import org.flasck.jvm.container.RenderTree;
import org.flasck.jvm.container.TemplateHolder;
import org.flasck.jvm.container.UpdatesDisplay;
import org.flasck.jvm.fl.ClientEnvironment;
import org.flasck.jvm.fl.HandlerInfo;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.ziwsh.intf.FieldsContainerWrapper;
import org.zinutils.exceptions.HaventConsideredThisException;
import org.zinutils.exceptions.NotImplementedException;

public class TemplateRenderer {
    public static final Logger logger = LoggerFactory.getLogger((String)"FlasckLib");

    public void _updateContent(FLEvalContext cx, RenderTree rt, String templateName, String field, int option, Object source, Object value, String fromField) {
        if (rt == null) {
            return;
        }
        CardContext ec = (CardContext)cx;
        value = cx.full(value);
        boolean usehtml = false;
        if (value == null) {
            value = "";
        } else if (value instanceof Double) {
            double d = (Double)value;
            long k = (int)d;
            if ((double)k == d && !Double.isInfinite(d)) {
                value = Long.toString(k);
            }
        } else if (value instanceof Html) {
            value = ((Html)value).getContent();
            usehtml = true;
        } else {
            value = value.toString();
        }
        Element currentDiv = ec.element(rt.id());
        Elements nodes = currentDiv.select("[data-flas-content='" + field + "']");
        if (nodes.size() > 0) {
            Element node = (Element)nodes.get(0);
            if (!node.hasAttr("id")) {
                String ncid = ec.nextDocumentId();
                RenderTree sub = rt.makeSub(field, ncid);
                if (source instanceof FieldsContainerWrapper && fromField != null) {
                    sub.setSource((FieldsContainerWrapper)source, fromField);
                }
                node.attr("id", ncid);
            }
            node.empty();
            if (usehtml) {
                node.append((String)value);
            } else {
                node.appendText((String)value);
            }
        }
    }

    public void _updateImage(FLEvalContext cx, RenderTree rt, String templateName, String field, int option, Object source, Object value, String fromField) {
        Element currentDiv;
        Elements nodes;
        CardContext ec = (CardContext)cx;
        value = cx.full(value);
        Image img = (Image)value;
        String imgSrc = "";
        if (img != null && img.getUri() != null) {
            imgSrc = img.getUri().toString();
        }
        if ((nodes = (currentDiv = ec.element(rt.id())).select("[data-flas-image='" + field + "']")).size() > 0) {
            Element node = (Element)nodes.get(0);
            if (!node.hasAttr("id")) {
                String ncid = ec.nextDocumentId();
                RenderTree sub = rt.makeSub(field, ncid);
                if (source instanceof FieldsContainerWrapper && fromField != null) {
                    sub.setSource((FieldsContainerWrapper)source, fromField);
                }
                node.attr("id", ncid);
            }
            node.attr("src", imgSrc);
        }
    }

    public void _updateLink(FLEvalContext cx, RenderTree rt, String templateName, String field, int option, Object source, Object value, String fromField) {
        Element currentDiv;
        Elements nodes;
        CardContext ec = (CardContext)cx;
        value = cx.full(value);
        Link l = (Link)value;
        String linkRef = "";
        String linkTitle = "";
        if (l != null) {
            linkRef = l.get("uri").toString();
            linkTitle = (String)l.get("title");
        }
        if ((nodes = (currentDiv = ec.element(rt.id())).select("[data-flas-link='" + field + "']")).size() > 0) {
            Element node = (Element)nodes.get(0);
            if (!node.hasAttr("id")) {
                String ncid = ec.nextDocumentId();
                RenderTree sub = rt.makeSub(field, ncid);
                if (source instanceof FieldsContainerWrapper && fromField != null) {
                    sub.setSource((FieldsContainerWrapper)source, fromField);
                }
                node.attr("id", ncid);
            }
            node.attr("href", linkRef);
            node.text(linkTitle);
        }
    }

    public void _updateStyles(FLEvalContext cx, UpdatesDisplay th, RenderTree rt, String templateName, String type, String field, int option, Object source, Object cexpr, Object ... vars) {
        RenderTree sub;
        Element node;
        CardContext ec = (CardContext)cx;
        Object styles = (String)cx.full(cexpr);
        if (styles == null) {
            styles = "";
        }
        ArrayList<Boolean> evconds = new ArrayList<Boolean>();
        for (int i = 0; i < vars.length; i += 2) {
            if (cx.isTruthy(vars[i])) {
                styles = (String)styles + " " + cx.full(vars[i + 1]);
                evconds.add(true);
                continue;
            }
            evconds.add(false);
        }
        Element div = ec.element(rt.id());
        if (type != null) {
            Elements nodes = div.select("[data-flas-" + type + "='" + field + "']");
            node = (Element)nodes.get(0);
            if (!node.hasAttr("id")) {
                String ncid = ec.nextDocumentId();
                sub = rt.makeSub(field, ncid);
                node.attr("id", ncid);
            } else {
                sub = rt.getSub(field);
            }
        } else {
            node = div;
            sub = rt;
        }
        node.attr("class", (String)styles);
        if (th != null) {
            th._attachHandlers(ec, sub, node, templateName, field, option, source, evconds);
        }
    }

    public void _updateTemplate(FLEvalContext cx, final TemplateHolder th, RenderTree rt, String type, String field, int position, final String template, Object expr, final List<Object> templateContext) {
        RenderTree sub;
        expr = cx.full(expr);
        final CardContext ec = (CardContext)cx;
        Element currentDiv = ec.element(rt.id());
        Elements nodes = currentDiv.select("[data-flas-" + type + "='" + field + "']");
        if (nodes.isEmpty()) {
            return;
        }
        final Element elt = nodes.first();
        if (!elt.hasAttr("id")) {
            String ncid = ec.nextDocumentId();
            sub = rt.makeSub(field, ncid);
            elt.attr("id", ncid);
        } else {
            sub = rt.getSub(field);
        }
        final Method m = this.findTemplateMethod(th, position);
        if (expr != null) {
            if (expr instanceof List) {
                List l = (List)expr;
                this._updateList(ec, sub, elt, sub.children(), l, new AddItemToContainer(){

                    @Override
                    public void add(RenderTree rt, Element ni, Object v, Integer before) {
                        TemplateRenderer.this._addItem(ec, th, rt, elt, ni, template, m, v, templateContext, before);
                    }
                });
            } else if (expr instanceof Crobag) {
                this._updateCrobag(ec, sub, elt, sub.children(), (Crobag)expr, new AddItemToContainer(){

                    @Override
                    public void add(RenderTree rt, Element ni, Object v, Integer before) {
                        TemplateRenderer.this._addItem(ec, th, rt, elt, ni, template, m, v, templateContext, before);
                    }
                });
            } else if (sub.children().size() == 1) {
                this._addItem(ec, th, sub, elt, elt.child(0), template, m, expr, templateContext, null);
            } else {
                this._addItem(ec, th, sub, elt, null, template, m, expr, templateContext, null);
            }
        }
    }

    private Method findTemplateMethod(TemplateHolder th, int position) {
        try {
            Method[] ms;
            for (Method m1 : ms = th.getClass().getDeclaredMethods()) {
                if (!m1.getName().equals("_updateTemplate" + position)) continue;
                return m1;
            }
            System.out.println("Could not find _updateTemplate" + position);
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private Element _addItem(CardContext ec, TemplateHolder th, RenderTree rt, Element parent, Element currNode, String template, Method m, Object value, List<Object> templateContext, Integer at) {
        if (currNode == null) {
            currNode = ec.newdiv();
            currNode.attr("id", rt.id());
            currNode.html(ec.getTemplate(template));
            if (at != null) {
                parent.insertChildren(at.intValue(), Arrays.asList(currNode));
            } else {
                parent.appendChild((Node)currNode);
            }
        }
        try {
            if (th == null) {
                logger.error("cannot handle null item in " + m);
                return currNode;
            }
            if (m.getParameterCount() == 2) {
                m.invoke((Object)th, ec, rt);
            } else {
                try {
                    m.invoke((Object)th, ec, rt, value, templateContext);
                }
                catch (Throwable t) {
                    logger.error("error with: " + value, t);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return currNode;
    }

    public void _updateContainer(FLEvalContext cx, final TemplateHolder th, RenderTree rt, String field, Object value, int posn) {
        RenderTree sub;
        value = cx.full(value);
        final CardContext ec = (CardContext)cx;
        Element currentDiv = ec.element(rt.id());
        Elements nodes = currentDiv.select("[data-flas-container='" + field + "']");
        if (nodes.isEmpty()) {
            return;
        }
        final Element elt = nodes.first();
        if (!elt.hasAttr("id")) {
            String ncid = ec.nextDocumentId();
            sub = rt.makeSub(field, ncid);
            elt.attr("id", ncid);
        } else {
            sub = rt.getSub(field);
        }
        Method m = null;
        try {
            Method[] ms;
            for (Method m1 : ms = th.getClass().getDeclaredMethods()) {
                if (!m1.getName().equals("_updateContainer" + posn)) continue;
                m = m1;
                break;
            }
            if (m == null) {
                System.out.println("Could not find _updateContainer" + posn);
                return;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        if (value == null) {
            while (elt.childNodes().size() > 0) {
                ((Node)elt.childNodes().get(0)).remove();
            }
            rt.children().clear();
            return;
        }
        final Method mi = m;
        if (value instanceof List) {
            List l = (List)value;
            this._updateList(ec, sub, elt, sub.children(), l, new AddItemToContainer(){

                @Override
                public void add(RenderTree rt, Element ni, Object v, Integer before) {
                    try {
                        mi.invoke((Object)th, ec, rt, elt, ni, v);
                    }
                    catch (Exception ex) {
                        System.out.println("invoking " + mi);
                        ex.printStackTrace();
                    }
                }
            });
        } else if (value instanceof Crobag) {
            this._updateCrobag(ec, sub, elt, sub.children(), (Crobag)value, new AddItemToContainer(){

                @Override
                public void add(RenderTree rt, Element ni, Object v, Integer before) {
                    try {
                        mi.invoke((Object)th, ec, rt, elt, ni, v);
                    }
                    catch (Exception ex) {
                        System.out.println("invoking " + mi);
                        ex.printStackTrace();
                    }
                }
            });
        } else {
            RenderTree single = sub.getSub("single");
            Element curr = null;
            if (single == null) {
                String ncid = ec.nextDocumentId();
                single = sub.makeSub("single", ncid);
            } else if (value.equals(single.value)) {
                curr = elt.child(0);
            } else {
                while (elt.childNodes().size() > 0) {
                    ((Node)elt.childNodes().get(0)).remove();
                }
                String ncid = ec.nextDocumentId();
                single = sub.makeSub("single", ncid);
            }
            try {
                mi.invoke((Object)th, ec, single, elt, curr, value);
            }
            catch (Exception ex) {
                System.out.println("invoking " + mi);
                ex.printStackTrace();
            }
        }
    }

    public void _updatePunnet(FLEvalContext cx, TemplateHolder th, RenderTree rt, String field, Object value, int posn) {
        block19: {
            block20: {
                RenderTree sub;
                Element elt;
                CardContext ec;
                block18: {
                    String ncid;
                    if (rt == null) {
                        return;
                    }
                    value = cx.full(value);
                    ec = (CardContext)cx;
                    Element currentDiv = ec.element(rt.id());
                    Elements nodes = currentDiv.select("[data-flas-punnet='" + field + "']");
                    if (nodes.isEmpty()) {
                        return;
                    }
                    elt = nodes.first();
                    if (!elt.hasAttr("id")) {
                        ncid = ec.nextDocumentId();
                        sub = rt.makeSub(field, ncid);
                        elt.attr("id", ncid);
                    } else {
                        sub = rt.getSub(field);
                    }
                    if (value == null) {
                        return;
                    }
                    if (!(value instanceof FLCard)) break block18;
                    if (sub.children().size() == 1 && sub.children().get((int)0).value == value) {
                        return;
                    }
                    sub.children().clear();
                    elt.html("");
                    ncid = ec.nextDocumentId();
                    sub.addChild(ncid, value);
                    Element pe = ec.newdiv();
                    pe.attr("id", ncid);
                    elt.appendChild((Node)pe);
                    ((FLCard)value)._renderInto(cx, pe);
                    break block19;
                }
                if (!(value instanceof List)) break block20;
                List cards = (List)value;
                SwitchOp sw = this._diffLists(sub.children(), cards);
                switch (sw.op) {
                    case "match": {
                        break;
                    }
                    case "addtoend": {
                        for (int i = sub.children().size(); i < cards.size(); ++i) {
                            Object o = cards.get(i);
                            String ncid = ec.nextDocumentId();
                            sub.addChild(ncid, o);
                            this.addCard(ec, o, ncid, elt);
                        }
                        break block19;
                    }
                    case "add": {
                        for (int i = 0; i < sw.additions.size(); ++i) {
                            Addition ai = sw.additions.get(i);
                            RenderTree srt = sub.addChild(ai.where, ec.nextDocumentId(), ai.value);
                            this.addCard(ec, ai.value, srt.id(), elt);
                            if (ai.where >= elt.children().size() - 1) continue;
                            Element extr = elt.children().last();
                            extr.remove();
                            elt.insertChildren(ai.where, Arrays.asList(extr));
                        }
                        break block19;
                    }
                    default: {
                        throw new HaventConsideredThisException("sw.op = " + sw.op);
                    }
                }
                break block19;
            }
            throw new HaventConsideredThisException("punnet value is " + value + " " + value.getClass());
        }
    }

    public void addCard(CardContext ec, Object o, String ncid, Element elt) {
        if (!(o instanceof FLCard)) {
            throw new HaventConsideredThisException("List without an object in it - probably an entity needs to be instantiated");
        }
        Element pe = ec.newdiv();
        pe.attr("id", ncid);
        elt.appendChild((Node)pe);
        ((FLCard)o)._renderInto(ec, pe);
    }

    public Element _addItemWithName(FLEvalContext cx, TemplateHolder th, RenderTree rt, Element parent, Element currNode, String templateName, int posn, Object value, List<Object> tc, Integer before) {
        return this._addItem((CardContext)cx, th, rt, parent, currNode, templateName, this.findTemplateMethod(th, posn), value, tc, before);
    }

    public void _updateCrobag(CardContext ec, RenderTree prt, Element parent, List<RenderTree> rts, Crobag crobag, AddItemToContainer cb) {
        int i = 0;
        for (CroEntry e : crobag) {
            if (i >= rts.size()) {
                RenderTree rt = prt.addChild(ec.nextDocumentId(), e);
                cb.add(rt, null, e.val, null);
            } else {
                int cmp = e.key.compareTo(((CroEntry)rts.get((int)i).value).key);
                if (cmp == 0) {
                    cb.add(rts.get(i), parent.child(i), e.val, null);
                } else if (cmp < 0) {
                    RenderTree rt = prt.addChild(i, ec.nextDocumentId(), e);
                    cb.add(rt, null, e.val, i);
                } else {
                    prt.removeChild(i);
                    parent.child(i).remove();
                }
            }
            ++i;
        }
    }

    public void _updateList(CardContext ec, RenderTree prt, Element parent, List<RenderTree> rts, List<Object> values, AddItemToContainer cb) {
        SwitchOp sw = this._diffLists(rts, values);
        switch (sw.op) {
            case "match": {
                for (int i = 0; i < values.size(); ++i) {
                    cb.add(rts.get(i), parent.child(i), values.get(i), null);
                }
                break;
            }
            case "addtoend": {
                int i;
                for (i = 0; i < rts.size(); ++i) {
                    cb.add(rts.get(i), parent.child(i), values.get(i), null);
                }
                for (i = rts.size(); i < values.size(); ++i) {
                    RenderTree rt = prt.addChild(ec.nextDocumentId(), values.get(i));
                    cb.add(rt, null, values.get(i), null);
                }
                break;
            }
            case "add": {
                int i;
                ArrayList<Integer> done = new ArrayList<Integer>();
                for (i = 0; i < sw.additions.size(); ++i) {
                    Addition ai = sw.additions.get(i);
                    RenderTree rt = prt.addChild(ai.where, ec.nextDocumentId(), ai.value);
                    cb.add(rt, null, ai.value, null);
                    if (ai.where < parent.children().size() - 1) {
                        Element extr = parent.children().last();
                        extr.remove();
                        parent.insertChildren(ai.where, Arrays.asList(extr));
                    }
                    done.add(ai.where);
                }
                for (i = 0; i < values.size(); ++i) {
                    if (done.contains(i)) continue;
                    cb.add(rts.get(i), parent.child(i), values.get(i), null);
                }
                break;
            }
            case "removefromend": {
                while (prt.children().size() > values.size()) {
                    parent.child(values.size()).remove();
                    prt.removeChild(values.size());
                }
                for (int i = 0; i < values.size(); ++i) {
                    cb.add(rts.get(i), parent.child(i), values.get(i), null);
                }
                break;
            }
            case "remove": {
                int i;
                for (i = 0; i < sw.removals.size(); ++i) {
                    int which = sw.removals.get(i);
                    prt.removeChild(which);
                    parent.child(which).remove();
                }
                for (i = 0; i < values.size(); ++i) {
                    cb.add(rts.get(i), parent.child(i), values.get(i), null);
                }
                break;
            }
            case "disaster": {
                TreeMap<String, NodeAndRT> map = new TreeMap<String, NodeAndRT>();
                while (!parent.children().isEmpty()) {
                    Element nd = (Element)parent.children().get(0);
                    nd.remove();
                    NodeAndRT nrt = new NodeAndRT(nd, prt.removeChild(0));
                    map.put(nrt.rt.id(), nrt);
                }
                for (int i = 0; i < values.size(); ++i) {
                    if (sw.mapping.containsKey(i)) {
                        String field = sw.mapping.get(i);
                        NodeAndRT nrt = (NodeAndRT)map.get(field);
                        parent.appendChild((Node)nrt.node);
                        rts.add(nrt.rt);
                        map.remove(field);
                        continue;
                    }
                    RenderTree rt = prt.addChild(ec.nextDocumentId(), values.get(i));
                    cb.add(rt, null, values.get(i), null);
                }
                break;
            }
            default: {
                throw new NotImplementedException("Cannot handle " + sw.op);
            }
        }
    }

    private SwitchOp _diffLists(List<RenderTree> rts, List<Object> values) {
        int k;
        int j;
        SwitchOp ret = new SwitchOp();
        boolean added = false;
        boolean removed = false;
        TreeSet<Integer> used = new TreeSet<Integer>();
        int i = 0;
        block0: for (j = 0; i < rts.size() && j < values.size(); ++j) {
            if (rts.get((int)i).value == values.get(j)) {
                ret.mapping.put(j, rts.get(i).id());
                used.add(i);
                ++i;
                continue;
            }
            for (k = i + 1; k < rts.size(); ++k) {
                if (values.get(j) != rts.get((int)k).value) continue;
                ret.mapping.put(j, rts.get(k).id());
                used.add(k);
                ret.removals.add(0, i);
                i = k + 1;
                removed = true;
                continue block0;
            }
            for (k = j + 1; k < values.size(); ++k) {
                if (values.get(k) != rts.get((int)i).value) continue;
                ret.mapping.put(k, rts.get(i).id());
                ret.additions.add(0, new Addition(i, values.get(j)));
                added = true;
                continue block0;
            }
            for (k = i - 1; k >= 0; --k) {
                if (used.contains(k) || values.get(j) != rts.get((int)k).value) continue;
                ret.mapping.put(j, rts.get(k).id());
                used.add(k);
                break;
            }
            removed = true;
            added = true;
            ++i;
        }
        if ((added || j < values.size()) && (removed || i < rts.size())) {
            ret.op = "disaster";
            while (j < values.size()) {
                for (k = 0; k < rts.size(); ++k) {
                    if (used.contains(k) || rts.get((int)k).value != values.get(j)) continue;
                    ret.mapping.put(j, rts.get(k).id());
                    used.add(k);
                    break;
                }
                ++j;
            }
        } else if (added) {
            ret.op = "add";
            while (j < values.size()) {
                ret.additions.add(0, new Addition(i++, values.get(j++)));
            }
        } else if (removed) {
            ret.op = "remove";
            while (i < rts.size()) {
                ret.removals.add(0, i++);
            }
        } else {
            ret.op = values.size() > rts.size() ? "addtoend" : (values.size() < rts.size() ? "removefromend" : "match");
        }
        return ret;
    }

    public void _attachHandlers(CardContext ec, UpdatesDisplay ud, RenderTree rt, Element div, String tn, String field, Integer option, Object source, List<Boolean> evconds) {
        Map<String, List<HandlerInfo>> evhs = ud._eventHandlers();
        List<HandlerInfo> list = evhs.get(tn);
        if (list == null || list.isEmpty()) {
            return;
        }
        if (rt != null) {
            for (ClientEnvironment.FireEvent fe : rt.events) {
                ec.removeEventFromCard(div, fe);
            }
            rt.clearEvents();
        }
        for (HandlerInfo hi : list) {
            if (hi.slot != null ? !hi.slot.equals(field) : field != null) continue;
            if (hi.option != null && option != null && !hi.option.equals(option) || evconds != null && hi.cond != null && !evconds.get(hi.cond).booleanValue()) continue;
            ClientEnvironment.FireEvent fe = ec.addEventToCard(ud, hi, div, source);
            if (rt == null) continue;
            rt.event(fe);
        }
    }

    private static interface AddItemToContainer {
        public void add(RenderTree var1, Element var2, Object var3, Integer var4);
    }

    private static class SwitchOp {
        String op;
        final List<Addition> additions = new ArrayList<Addition>();
        final List<Integer> removals = new ArrayList<Integer>();
        final Map<Integer, String> mapping = new TreeMap<Integer, String>();

        private SwitchOp() {
        }
    }

    public class Addition {
        final int where;
        final Object value;

        public Addition(int where, Object value) {
            this.where = where;
            this.value = value;
        }
    }

    public class NodeAndRT {
        final Element node;
        final RenderTree rt;

        public NodeAndRT(Element nd, RenderTree rt) {
            this.node = nd;
            this.rt = rt;
        }
    }
}

