/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.jvm.container;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.flasck.jvm.container.ValueSource;
import org.flasck.jvm.fl.ClientEnvironment;
import org.ziniki.ziwsh.intf.FieldsContainerWrapper;

public class RenderTree {
    private final String id;
    public final List<ClientEnvironment.FireEvent> events = new ArrayList<ClientEnvironment.FireEvent>();
    private final Map<String, RenderTree> subs = new TreeMap<String, RenderTree>();
    private final List<RenderTree> children = new ArrayList<RenderTree>();
    private ValueSource source;
    public final Object value;

    public RenderTree(String id) {
        this.id = id;
        this.value = null;
    }

    public RenderTree(String nid, Object value) {
        this.id = nid;
        this.value = value;
    }

    public String id() {
        return this.id;
    }

    public RenderTree makeSub(String as, String id) {
        RenderTree ret = new RenderTree(id);
        this.subs.put(as, ret);
        return ret;
    }

    public RenderTree getSub(String id) {
        return this.subs.get(id);
    }

    public RenderTree addChild(String nid, Object value) {
        RenderTree ret = new RenderTree(nid, value);
        this.children.add(ret);
        return ret;
    }

    public RenderTree addChild(int where, String nid, Object value) {
        RenderTree ret = new RenderTree(nid, value);
        this.children.add(where, ret);
        return ret;
    }

    public RenderTree removeChild(int which) {
        return this.children.remove(which);
    }

    public List<RenderTree> children() {
        return this.children;
    }

    public void event(ClientEnvironment.FireEvent fe) {
        this.events.add(fe);
    }

    public void clearEvents() {
        this.events.clear();
    }

    public Map<String, RenderTree> subs() {
        return this.subs;
    }

    public void setSource(FieldsContainerWrapper fcw, String fld) {
        this.source = new ValueSource(fcw, fld);
    }

    public void bind(Object value) {
        if (this.source != null) {
            this.source.bind(value);
        } else {
            System.out.println("could not bind because no source");
        }
    }
}

