/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.jvm.container;

import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.flasck.jvm.FLEvalContext;
import org.flasck.jvm.container.BoundVar;
import org.flasck.jvm.container.CardContext;
import org.flasck.jvm.container.ExpectationException;
import org.flasck.jvm.container.ExpectationInstance;
import org.flasck.jvm.container.ExpectationsForMethod;
import org.flasck.jvm.container.UnusedExpectationException;
import org.flasck.jvm.fl.JVMTestHelper;
import org.flasck.jvm.fl.MockExpectation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.ziwsh.intf.EvalContext;
import org.ziniki.ziwsh.intf.IdempotentHandler;
import org.ziniki.ziwsh.intf.NamedIdempotentHandler;
import org.ziniki.ziwsh.intf.ServiceFor;

public class MockContract
implements InvocationHandler {
    public final Logger logger = LoggerFactory.getLogger((String)"Mock");
    private final CardContext collector;
    private final Class<?> ctr;
    private final Map<String, ExpectationsForMethod> expected = new TreeMap<String, ExpectationsForMethod>();

    public MockContract(CardContext collector, Class<?> ctr) {
        this.collector = collector;
        this.ctr = ctr;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object handle;
        Object[] as;
        switch (method.getName()) {
            case "_areYouA": {
                return this.ctr.getName().replace("$", ".").equals(args[1]);
            }
            case "equals": {
                return args.length == 1 && proxy == args[0];
            }
            case "expect": {
                return this.handleExpectations(args);
            }
            case "assertSatisfied": {
                this.assertSatisfied(args);
                return null;
            }
            case "hashCode": {
                return this.ctr.hashCode() ^ method.hashCode();
            }
            case "toString": {
                return "MockContract[" + this.ctr.getName() + "]";
            }
        }
        FLEvalContext cx = (FLEvalContext)args[0];
        String meth = method.getName();
        if (IdempotentHandler.class.isAssignableFrom(method.getDeclaringClass())) {
            as = (Object[])args[1];
            if (as.length > 0 && as[as.length - 1] instanceof IdempotentHandler) {
                handle = as[as.length - 1];
                as = Arrays.copyOfRange(as, 0, as.length - 1);
            } else {
                handle = null;
            }
        } else {
            Object[] tmp = (Object[])args[1];
            as = new Object[tmp.length - 1];
            for (int i = 0; i < tmp.length - 1; ++i) {
                as[i] = tmp[i];
            }
            handle = tmp[tmp.length - 1];
        }
        return this.dispatch(cx, meth, Arrays.asList(as), handle);
    }

    private MockExpectation handleExpectations(Object[] args) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        int actual;
        String name = (String)args[0];
        Method meth = this.findMethod(this.ctr, name);
        if (meth == null) {
            throw new ExpectationException(this.ctr.getName() + " does not have a method " + name);
        }
        Field f = this.ctr.getField("_nf_" + name);
        int nfargs = (Integer)f.get(this.ctr);
        if (nfargs != (actual = ((Object[])args[1]).length)) {
            throw new ExpectationException(this.ctr.getName() + "." + name + " expects " + nfargs + " parameters but received " + actual);
        }
        ExpectationsForMethod exp = null;
        if (this.expected.containsKey(name)) {
            exp = this.expected.get(name);
        } else {
            exp = new ExpectationsForMethod();
            this.expected.put(name, exp);
        }
        ExpectationInstance ret = new ExpectationInstance((Object[])args[1], args[2]);
        exp.cases.add(ret);
        return ret;
    }

    private Method findMethod(Class<?> clz, String name) {
        Method meth;
        Method[] declaredMethods = clz.getDeclaredMethods();
        for (Method method : declaredMethods) {
            if (!method.getName().equals(name)) continue;
            return method;
        }
        if (clz.getSuperclass() != null && (meth = this.findMethod(clz.getSuperclass(), name)) != null) {
            return meth;
        }
        for (GenericDeclaration genericDeclaration : clz.getInterfaces()) {
            Method meth2 = this.findMethod((Class<?>)genericDeclaration, name);
            if (meth2 == null) continue;
            return meth2;
        }
        return null;
    }

    private void assertSatisfied(Object[] args) {
        for (Map.Entry<String, ExpectationsForMethod> e : this.expected.entrySet()) {
            ExpectationsForMethod em = e.getValue();
            int cn = 0;
            for (ExpectationInstance c : em.cases) {
                if (c.invoked != c.allowed) {
                    throw new UnusedExpectationException(this.ctr.getName() + "." + e.getKey() + " <" + cn + ">");
                }
                ++cn;
            }
        }
    }

    public Object dispatch(FLEvalContext cx, String meth, List<Object> args, Object handle) {
        if (!this.expected.containsKey(meth)) {
            this.collector.error(new ExpectationException("There are no expectations on " + this.ctr.getName() + " for " + meth));
            return null;
        }
        ExpectationsForMethod e = this.expected.get(meth);
        for (ExpectationInstance ei : e.cases) {
            boolean found = true;
            for (int i = 0; i < args.size(); ++i) {
                if (cx.compare(args.get(i), ei.args[i])) continue;
                found = false;
                break;
            }
            if (!found || ei.invoked >= ei.allowed) continue;
            ++ei.invoked;
            this.logger.debug("Have invocation of " + this.ctr.getName() + "." + meth);
            if (ei.handler instanceof BoundVar) {
                NamedIdempotentHandler nih;
                BoundVar bv = (BoundVar)ei.handler;
                bv.bindActual(handle);
                if (handle instanceof NamedIdempotentHandler && (nih = (NamedIdempotentHandler)handle).ihid() != null) {
                    cx.getBroker().serviceFor(nih.ihid(), (ServiceFor)new SubscriptionFor(bv.getName(), nih.ihid()));
                }
            }
            return null;
        }
        StringBuilder argList = new StringBuilder();
        for (Object a : args) {
            argList.append(" ");
            argList.append(a);
        }
        this.collector.error(new ExpectationException("Unexpected invocation: " + this.ctr.getName() + "." + meth + argList));
        return null;
    }

    public String toString() {
        return "InvocationHandlerForMockContract[" + this.ctr + "]";
    }

    public class SubscriptionFor
    implements ServiceFor {
        private String varName;
        private String handlerName;

        public SubscriptionFor(String varName, String handlerName) {
            this.varName = varName;
            this.handlerName = handlerName;
        }

        public void cancel(EvalContext cx) {
            ((JVMTestHelper)((FLEvalContext)cx).getEnvironment()).cancelBound(this.varName, this.handlerName);
        }
    }
}

