/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.jvm.container;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.flasck.jvm.FLEvalContext;
import org.flasck.jvm.builtin.FLError;
import org.flasck.jvm.builtin.Message;
import org.flasck.jvm.container.Dispatcher;
import org.flasck.jvm.container.UpdatesDisplay;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zinutils.exceptions.CantHappenException;
import org.zinutils.exceptions.NotImplementedException;

public class JvmDispatcher
implements Dispatcher {
    private static final Logger logger = LoggerFactory.getLogger((String)"Dispatcher");
    private static String patienceChild = System.getProperty("org.flasck.patience.child");
    private boolean wantTimeout = patienceChild == null || !patienceChild.equals("true");
    private final int queueDelay;
    private final String name;
    private final List<Object> queue = Collections.synchronizedList(new ArrayList());
    private final ExecutorService exec = Executors.newSingleThreadExecutor();
    private final AtomicBoolean processing = new AtomicBoolean();
    private final AtomicInteger queueDepth = new AtomicInteger(0);

    public JvmDispatcher(String name, int queueDelay) {
        this.name = name;
        this.queueDelay = queueDelay;
    }

    @Override
    public void queueMessages(FLEvalContext cxt, Object msgs) {
        logger.info(this.name + " queuing " + msgs);
        this.queueDepth.getAndIncrement();
        this.queue.add(msgs);
        this.exec.execute(() -> this.dispatchMessages(cxt));
    }

    @Override
    public void close() throws InterruptedException {
        this.exec.shutdownNow();
        this.exec.awaitTermination(10L, TimeUnit.SECONDS);
    }

    @Override
    public boolean isDone() {
        return this.queueDepth.get() == 0;
    }

    @Override
    public void waitForQueueDone() throws TimeoutException {
        AtomicBoolean atomicBoolean = this.processing;
        synchronized (atomicBoolean) {
            Date d = new Date(new Date().getTime() + 12500L);
            while (new Date().before(d) || !this.wantTimeout) {
                if (this.queue.isEmpty() && !this.processing.get() && this.queueDepth.get() == 0) {
                    return;
                }
                logger.info(this.name + " starting to wait ... " + this.queue.size() + " " + this.processing + " depth = " + this.queueDepth.get());
                try {
                    this.processing.wait(this.queueDelay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                logger.info(this.name + " finished wait ... " + this.queue.size() + " " + this.processing + " " + this.queueDepth.get());
            }
            throw new TimeoutException("queue = " + this.queue.size() + " " + this.processing.get() + " " + this.queueDepth.get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchMessages(FLEvalContext cxt) {
        AtomicBoolean atomicBoolean = this.processing;
        synchronized (atomicBoolean) {
            logger.info(this.name + " starting to dispatch messages");
            this.processing.set(true);
        }
        cxt.enterEventLoop();
        while (!this.queue.isEmpty()) {
            logger.info(this.name + " dispatching ... " + this.queue.size());
            Object msgs = this.queue.remove(0);
            try {
                logger.info(this.name + " processing " + msgs);
                this.handleMessages(cxt, msgs);
            }
            catch (Throwable t) {
                logger.error("Error processing " + msgs, t);
                break;
            }
        }
        Set<UpdatesDisplay> updates = cxt.leaveEventLoop();
        for (UpdatesDisplay ud : updates) {
            ud._updateDisplay(cxt, ud._renderTree());
        }
        AtomicBoolean atomicBoolean2 = this.processing;
        synchronized (atomicBoolean2) {
            this.processing.set(false);
            if (this.queueDepth.decrementAndGet() == 0) {
                logger.info(this.name + " notifying ...");
                this.processing.notifyAll();
            }
        }
    }

    @Override
    public void handleMessages(FLEvalContext cxt, Object msg) {
        msg = cxt.full(msg);
        logger.info(this.name + " handling " + msg);
        this.handleWith(cxt, msg);
    }

    private void handleWith(FLEvalContext cxt, Object msg) {
        logger.info(this.name + " handleWith " + msg);
        if (msg != null) {
            if (msg instanceof FLError) {
                System.out.println(msg);
            } else if (msg instanceof Collection) {
                Collection c = (Collection)msg;
                for (Object o : c) {
                    o = cxt.full(o);
                    this.handleMessages(cxt, o);
                }
            } else if (msg instanceof Message) {
                Object r = ((Message)msg).dispatch(cxt);
                this.handleMessages(cxt, r);
            } else {
                throw new NotImplementedException("cannot handle message " + msg + " of type " + msg.getClass());
            }
        }
    }

    @Override
    public void addAll(List<Object> ret, Object r) {
        if (r != null) {
            if (r instanceof FLError) {
                System.out.println(r);
            } else if (r instanceof List) {
                List res = (List)r;
                for (Object o : res) {
                    this.addAll(ret, o);
                }
            } else if (r instanceof Message) {
                ret.add(r);
            } else {
                throw new CantHappenException("return must be message or List[Message] not " + r);
            }
        }
    }
}

