/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.jvm.container;

import java.util.List;
import java.util.Map;
import org.flasck.jvm.FLEvalContext;
import org.flasck.jvm.container.CardContext;
import org.flasck.jvm.container.ContractHolder;
import org.flasck.jvm.container.EventsHolder;
import org.flasck.jvm.container.RenderTree;
import org.flasck.jvm.container.TemplateHolder;
import org.flasck.jvm.container.TemplateRenderer;
import org.flasck.jvm.container.UpdatesDisplay;
import org.flasck.jvm.fl.HandlerInfo;
import org.jsoup.nodes.Element;
import org.zinutils.exceptions.CantHappenException;

public abstract class FLCard
extends ContractHolder
implements TemplateHolder,
UpdatesDisplay,
EventsHolder {
    protected String _rootTemplate;
    public RenderTree _renderTree;
    private final TemplateRenderer _renderer = new TemplateRenderer();
    private Element _containedIn;

    protected FLCard(FLEvalContext cx, String rootTemplate) {
        super(cx);
        this._rootTemplate = rootTemplate;
    }

    @Override
    public String _containedIn() {
        return this._containedIn.attr("id");
    }

    public void _renderInto(FLEvalContext cx, Element div) {
        this._containedIn = div;
        CardContext ec = (CardContext)cx;
        div.empty();
        if (this._rootTemplate != null) {
            String rt = ec.getTemplate(this._rootTemplate);
            if (rt == null) {
                throw new CantHappenException("there is no template for " + this._rootTemplate);
            }
            div.html(rt);
            String ncid = ec.nextDocumentId();
            div.child(0).attr("id", ncid);
            this._renderTree = new RenderTree(ncid);
        }
        this._updateDisplay(cx, this._renderTree);
        this._attachHandlers(ec, this._renderTree, this._containedIn, "_", null, 1, this, null);
    }

    @Override
    public void _updateContent(FLEvalContext cx, RenderTree rt, String templateName, String field, int option, Object source, Object value, String fromField) {
        this._renderer._updateContent(cx, rt, templateName, field, option, source == null ? this : source, value, fromField);
    }

    public void _updateImage(FLEvalContext cx, RenderTree rt, String templateName, String field, int option, Object source, Object value, String fromField) {
        this._renderer._updateImage(cx, rt, templateName, field, option, source == null ? this : source, value, fromField);
    }

    public void _updateLink(FLEvalContext cx, RenderTree rt, String templateName, String field, int option, Object source, Object value, String fromField) {
        this._renderer._updateLink(cx, rt, templateName, field, option, source == null ? this : source, value, fromField);
    }

    @Override
    public void _updateStyles(FLEvalContext cx, RenderTree rt, String templateName, String type, String field, int option, Object source, Object styles, Object ... vars) {
        this._renderer._updateStyles(cx, this, rt, templateName, type, field, option, source, styles, vars);
    }

    @Override
    public void _updateTemplate(FLEvalContext cx, RenderTree rt, String type, String field, int position, String template, Object expr, List<Object> templateContext) {
        this._renderer._updateTemplate(cx, this, rt, type, field, position, template, expr, templateContext);
    }

    public void _updateContainer(FLEvalContext cx, RenderTree rt, String field, Object value, int posn) {
        this._renderer._updateContainer(cx, this, rt, field, value, posn);
    }

    public void _updatePunnet(FLEvalContext cx, RenderTree rt, String field, Object value, int posn) {
        this._renderer._updatePunnet(cx, this, rt, field, value, posn);
    }

    @Override
    public void _attachHandlers(CardContext ec, RenderTree rt, Element div, String tn, String field, Integer option, Object source, List<Boolean> evconds) {
        this._renderer._attachHandlers(ec, this, rt, div, tn, field, option, source, evconds);
    }

    public void _addItemWithName(FLEvalContext cx, RenderTree rt, Element parent, Element currNode, String templateName, int posn, Object value, List<Object> tc) {
        Element elt = this._renderer._addItemWithName(cx, this, rt, parent, currNode, templateName, posn, value, tc, null);
        if (this._rootTemplate != null) {
            this._attachHandlers((CardContext)cx, rt, elt, templateName, null, null, value, null);
        }
    }

    public Element _currentDiv(FLEvalContext cx) {
        CardContext ec = (CardContext)cx;
        return ec.element(this._renderTree.id());
    }

    @Override
    public abstract Map<String, List<HandlerInfo>> _eventHandlers();

    public String _rootTemplate() {
        return this._rootTemplate;
    }

    @Override
    public RenderTree _renderTree() {
        return this._renderTree;
    }

    @Override
    public void _updateDisplay(FLEvalContext cx, RenderTree rt) {
    }

    @Override
    public void _updateFromInputs() {
        if (this._renderTree != null) {
            this._updateFromInputs(this._renderTree);
        }
    }

    protected void _updateFromInputs(RenderTree rt) {
        CardContext ec = (CardContext)this.cx;
        for (RenderTree renderTree : rt.children()) {
            this._updateFromInputs(renderTree);
        }
        for (Map.Entry entry : rt.subs().entrySet()) {
            RenderTree s = (RenderTree)entry.getValue();
            String eltId = s.id();
            Element x = ec.element(eltId);
            if (!x.tagName().equals("input") || !x.hasAttr("type") || !x.attr("type").equals("text") && !x.attr("type").equals("password")) continue;
            s.bind(x.attr("value"));
        }
    }
}

