/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.jvm.container;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flasck.jvm.FLEvalContext;
import org.flasck.jvm.builtin.Message;
import org.flasck.jvm.builtin.UpdateDisplay;
import org.flasck.jvm.container.CardContext;
import org.flasck.jvm.container.EnterEvent;
import org.flasck.jvm.container.FLCard;
import org.flasck.jvm.container.FLCardAssignment;
import org.flasck.jvm.container.FLRoutingAction;
import org.flasck.jvm.container.FLRoutingArg;
import org.flasck.jvm.container.MoveDownEvent;
import org.flasck.jvm.container.MoveUpEvent;
import org.flasck.jvm.container.RenderTree;
import org.flasck.jvm.container.SecurityModule;
import org.flasck.jvm.container.UpdatesDisplay;
import org.flasck.jvm.fl.ClientContext;
import org.flasck.jvm.fl.HandlerInfo;
import org.jsoup.nodes.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zinutils.exceptions.NotImplementedException;
import org.zinutils.reflection.Reflection;

public abstract class FLApplication
implements UpdatesDisplay {
    public static final Logger tracker = LoggerFactory.getLogger((String)"CallTracker");
    private final Element topdiv;
    final Map<String, FLCard> bindings = new HashMap<String, FLCard>();
    private final Map<String, String> params = new HashMap<String, String>();
    protected SecurityModule securityModule;
    protected String title;
    List<RouteStep> currentRoute;
    private URI currentPath;
    private String rememberedRoute;

    public FLApplication(ClientContext cxt, Element topdiv) {
        this.topdiv = topdiv;
        this.currentPath = URI.create(this.baseUri());
    }

    public void _bindSecurity(SecurityModule securityModule) {
        this.securityModule = securityModule;
    }

    public SecurityModule security() {
        return this.securityModule;
    }

    public void nowLoggedIn(FLEvalContext cx) {
        this.gotoRoute(cx, this.rememberedRoute);
    }

    public void gotoRoute(FLEvalContext cx, String route) {
        Map<String, Object> routing = this._routing();
        boolean secure = (Boolean)routing.get("secure");
        if (secure) {
            if (!this.securityModule.requireLogin(cx, this.topdiv)) {
                this.rememberedRoute = route;
                return;
            }
            this.rememberedRoute = null;
        }
        EnterEvent ev = null;
        if (this.currentRoute == null) {
            ev = new EnterEvent(this, this.topdiv);
            this.currentRoute = new ArrayList<RouteStep>();
            this.currentRoute.add(new RouteStep(routing));
            this._createCards(cx, ev, (List)routing.get("cards"));
            this._routeActions(cx, ev, (List)routing.get("enter"));
            this._routeActions(cx, ev, (List)routing.get("at"));
            this._readyCards(cx, ev, (List)routing.get("cards"));
        }
        List<String> path = this.parseRoute(route);
        int cmn = this.removeCommon(path);
        Message re = this.currentRoute.size() > cmn + 1 ? new MoveUpEvent(this, cmn, path) : new MoveDownEvent(this, this.currentRoute.get((int)cmn).routes, path);
        if (ev != null) {
            ev.andThen(re);
            cx.queueMessages(ev);
        } else {
            cx.queueMessages(re);
        }
    }

    private List<String> parseRoute(String route) {
        if (((String)route).startsWith("/")) {
            route = this.baseUri() + (String)route;
        }
        if (!((String)route).endsWith("/")) {
            route = (String)route + "/";
        }
        this.currentPath = this.currentPath.resolve((String)route).normalize();
        route = this.currentPath.toString();
        route = ((String)route).replace(this.baseUri(), "");
        route = ((String)route).replaceFirst("^#*", "");
        route = ((String)route).replaceFirst("^/*", "");
        ArrayList<String> ret = new ArrayList<String>();
        for (String s : ((String)route).split("/")) {
            if (s.equals("")) continue;
            ret.add(s);
        }
        return ret;
    }

    private int removeCommon(List<String> path) {
        int cmn = 0;
        while (!path.isEmpty() && cmn + 1 < this.currentRoute.size() && path.get(0).equals(this.currentRoute.get((int)(cmn + 1)).routes.get("path"))) {
            path.remove(0);
            ++cmn;
        }
        return cmn;
    }

    void moveDown(FLEvalContext cx, Map<String, Object> routing, List<String> path) {
        if (routing.containsKey("title")) {
            this.title = (String)routing.get("title");
        }
        if (path == null || path.isEmpty()) {
            cx.queueMessages(new UpdateDisplay(cx, this));
            return;
        }
        List routes = (List)routing.get("routes");
        if (routes == null) {
            return;
        }
        String first = path.remove(0);
        for (Map rr : routes) {
            if (rr.get("param") == null && !first.equals(rr.get("path"))) continue;
            if (rr.get("param") != null) {
                this.params.put((String)rr.get("param"), first);
            }
            this.currentRoute.add(new RouteStep(rr));
            EnterEvent ev = new EnterEvent(this, null);
            this._createCards(cx, ev, (List)rr.get("cards"));
            this._routeActions(cx, ev, (List)rr.get("enter"));
            this._routeActions(cx, ev, (List)rr.get("at"));
            this._readyCards(cx, ev, (List)rr.get("cards"));
            ev.andThen(new MoveDownEvent(this, rr, path));
            cx.queueMessages(ev);
            break;
        }
    }

    public void moveUp(FLEvalContext cx) {
        RouteStep exiting = this.currentRoute.remove(this.currentRoute.size() - 1);
        EnterEvent ev = new EnterEvent(this, null);
        this._routeActions(cx, ev, (List)exiting.routes.get("exit"));
        this._closeCards(cx, ev, (List)exiting.routes.get("cards"));
        this._routeActions(cx, ev, (List)this.currentRoute.get((int)(this.currentRoute.size() - 1)).routes.get("at"));
        cx.queueMessages(ev);
        cx.queueMessages(new UpdateDisplay(cx, this));
    }

    private void _createCards(FLEvalContext cx, EnterEvent ev, List<FLCardAssignment> cards) {
        for (FLCardAssignment ca : cards) {
            ev.add(() -> {
                FLCard card = (FLCard)Reflection.create((ClassLoader)cx.getLoader(), (String)ca.card, (Object[])new Object[]{cx});
                this.bindings.put(ca.name, card);
            });
        }
    }

    private void _closeCards(FLEvalContext cx, EnterEvent ev, List<FLCardAssignment> cards) {
        for (FLCardAssignment ca : cards) {
            ev.add(() -> {
                FLCard card = this.bindings.get(ca.name);
                if (card == null) {
                    return;
                }
                Object lc = card.contractImpl(cx, "Lifecycle");
                if (lc != null) {
                    try {
                        tracker.info("invoke Lifecycle.closing");
                        Object evs = Reflection.call((Object)lc, (String)"closing", (Object[])new Object[]{cx, new Object[0]});
                        cx.queueMessages(evs);
                    }
                    catch (RuntimeException evs) {
                        // empty catch block
                    }
                }
                if (card._renderTree != null) {
                    Element elt = ((CardContext)cx).element(card._renderTree.id());
                    elt.remove();
                    card._renderTree = null;
                }
            });
        }
    }

    private void _routeActions(FLEvalContext cx, EnterEvent ev, List<FLRoutingAction> actions) {
        if (actions == null) {
            return;
        }
        for (FLRoutingAction ra : actions) {
            ev.add(() -> {
                FLCard card = this.bindings.get(ra.card);
                if (card == null) {
                    return;
                }
                Object lc = card.contractImpl(cx, ra.contract);
                if (lc != null) {
                    try {
                        tracker.info("invoke " + ra.contract + "." + ra.action);
                        ArrayList<Object> args = new ArrayList<Object>();
                        block8: for (FLRoutingArg aa : ra.args) {
                            switch (aa.type) {
                                case STRING: {
                                    args.add(aa.value);
                                    continue block8;
                                }
                                case PARAM: {
                                    args.add(this.params.get(aa.value));
                                    continue block8;
                                }
                                case CARDREF: {
                                    args.add(this.bindings.get(aa.value));
                                    continue block8;
                                }
                                case EXPR: {
                                    args.add(Reflection.call((Object)this, (String)aa.value, (Object[])new Object[]{cx}));
                                    continue block8;
                                }
                                default: {
                                    throw new NotImplementedException();
                                }
                            }
                        }
                        Object evs = Reflection.call((Object)lc, (String)ra.action, (Object[])new Object[]{cx, args.toArray()});
                        cx.queueMessages(evs);
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
            });
        }
    }

    private void _readyCards(FLEvalContext cx, EnterEvent ev, List<FLCardAssignment> cards) {
        for (FLCardAssignment ca : cards) {
            ev.add(() -> {
                FLCard card = this.bindings.get(ca.name);
                if (card == null) {
                    return;
                }
                Object lc = card.contractImpl(cx, "Lifecycle");
                if (lc != null) {
                    try {
                        tracker.info("invoke Lifecycle.ready");
                        Object evs = Reflection.call((Object)lc, (String)"ready", (Object[])new Object[]{cx, new Object[0]});
                        cx.queueMessages(evs);
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
            });
        }
    }

    public FLCard card(String name) {
        return this.bindings.get(name);
    }

    @Override
    public RenderTree _renderTree() {
        FLCard card = this.bindings.get("main");
        if (card == null) {
            return null;
        }
        return card._renderTree();
    }

    @Override
    public void _updateDisplay(FLEvalContext cxt, RenderTree rt) {
        FLCard card;
        if (this.title != null) {
            ((CardContext)cxt).setTitle(this.title);
        }
        if ((card = this.bindings.get("main")) == null) {
            return;
        }
        card._updateDisplay(cxt, rt);
    }

    @Override
    public void _updateFromInputs() {
        throw new NotImplementedException();
    }

    @Override
    public String _containedIn() {
        throw new NotImplementedException();
    }

    @Override
    public Map<String, List<HandlerInfo>> _eventHandlers() {
        throw new NotImplementedException();
    }

    @Override
    public void _attachHandlers(CardContext ec, RenderTree sub, Element node, String templateName, String field, Integer option, Object source, List<Boolean> evconds) {
        throw new NotImplementedException();
    }

    protected abstract String baseUri();

    protected abstract Map<String, Object> _routing();

    public class RouteStep {
        final Map<String, Object> routes;

        public RouteStep(Map<String, Object> rr) {
            this.routes = rr;
        }
    }
}

