/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.jvm.container;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.flasck.jvm.FLEvalContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.ziwsh.intf.DispatchInfo;
import org.ziniki.ziwsh.intf.Dispatcher;
import org.ziniki.ziwsh.intf.EvalContext;
import org.ziniki.ziwsh.intf.IdempotentHandler;
import org.ziniki.ziwsh.intf.MarshallingTraverser;
import org.ziniki.ziwsh.jvm.ArgListMarshaller;
import org.zinutils.exceptions.CantHappenException;

public class FLASDispatcher
implements Dispatcher {
    public static final Logger tracker = LoggerFactory.getLogger((String)"CallTracker");

    public Object dispatch(EvalContext cx, DispatchInfo di) throws ClassNotFoundException {
        if (di.args.length == 2 && di.args[1] instanceof Object[]) {
            new ArgListMarshaller(true, true).marshal(cx, (MarshallingTraverser)di.ux, (Object[])di.args[1]);
        } else {
            new ArgListMarshaller(false, true).marshal(cx, (MarshallingTraverser)di.ux, di.args);
        }
        return di.ux.dispatch();
    }

    public void invokeName(IdempotentHandler ih, String method, Object[] args) {
        block7: {
            try {
                Object foo;
                FLEvalContext cx;
                block8: {
                    cx = ((FLEvalContext)args[0]).bindSubContext(ih);
                    if (method.equals("success")) {
                        ih.success((EvalContext)cx);
                        break block7;
                    }
                    if (method.equals("failure")) {
                        ih.failure((EvalContext)cx, (Object)((String)args[1]));
                        break block7;
                    }
                    tracker.info("-> " + ih.getClass().getName() + "." + method);
                    foo = null;
                    try {
                        Method m = ih.getClass().getMethod(method, FLEvalContext.class, Object[].class);
                        foo = m.invoke((Object)ih, cx, this.from(args, 1));
                    }
                    catch (NoSuchMethodException e) {
                        boolean done = false;
                        Method[] ms = ih.getClass().getMethods();
                        for (int i = 0; i < ms.length; ++i) {
                            if (!ms[i].getName().equals(method)) continue;
                            Method m = ms[i];
                            foo = m.invoke((Object)ih, args);
                            done = true;
                            break;
                        }
                        if (done) break block8;
                        throw new CantHappenException("there is no method " + method + " on " + ih.getClass());
                    }
                }
                cx.queueMessages(foo);
            }
            catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
                e.printStackTrace(System.out);
            }
        }
    }

    public Object invoke(Object svc, Method method, Object[] args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (method.getParameterCount() == 2 && method.getParameterTypes()[1].isArray()) {
            return method.invoke(svc, args[0], this.from(args, 1));
        }
        return method.invoke(svc, args);
    }

    public void marshalArgs(EvalContext cx, MarshallingTraverser m, Object[] args) throws ClassNotFoundException {
        if (args.length == 1) {
            new ArgListMarshaller(true, true).marshal(cx, m, new Object[0]);
        } else if (args[1] instanceof Object[]) {
            new ArgListMarshaller(true, true).marshal(cx, m, (Object[])args[1]);
        } else {
            new ArgListMarshaller(true, true).marshal(cx, m, this.from(args, 1));
        }
    }

    public Object[] from(Object[] args, int f) {
        Object[] ret = new Object[args.length - f];
        for (int i = f; i < args.length; ++i) {
            ret[i - f] = args[i];
        }
        return ret;
    }
}

