/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.jvm.builtin;

import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import org.flasck.jvm.FLEvalContext;
import org.flasck.jvm.fl.FLComparable;
import org.ziniki.ziwsh.intf.ObjectMarshalling;
import org.ziniki.ziwsh.intf.Wireable;

public class TypeOf
implements Wireable,
FLComparable {
    public static final int nfargs = 1;
    private final String name;

    public TypeOf(Class<?> clz) {
        this.name = clz.getName();
    }

    public TypeOf(String name) {
        this.name = name;
    }

    public static Object eval(FLEvalContext cx, Object ... args) {
        Object f = cx.full(args[0]);
        return new TypeOf(f.getClass().getName());
    }

    public String typeName() {
        if (this.name.equals(Double.class.getName())) {
            return "Number";
        }
        if (this.name.equals(String.class.getName())) {
            return "String";
        }
        if (this.name.equals(TypeOf.class.getName())) {
            return "Type";
        }
        return this.name;
    }

    @Override
    public boolean equalTo(FLEvalContext cxt, Object other) {
        if (!(other instanceof TypeOf)) {
            return false;
        }
        TypeOf o = (TypeOf)other;
        return this.name.equals(o.name);
    }

    public String toString() {
        return "Type[" + this.name + "]";
    }

    public Map<String, Object> fields() throws IOException {
        TreeMap<String, Object> ret = new TreeMap<String, Object>();
        ret.put("type", this.typeName());
        return ret;
    }

    public static TypeOf fromWire(FLEvalContext cx, ObjectMarshalling om, Map<String, Object> args) {
        return new TypeOf((String)args.get("type"));
    }
}

