/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.jvm.builtin;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.flasck.jvm.FLEvalContext;
import org.flasck.jvm.builtin.ContainsCard;
import org.flasck.jvm.builtin.Message;
import org.flasck.jvm.builtin.UpdateDisplay;
import org.flasck.jvm.container.MockContract;
import org.flasck.jvm.container.ResponseWithMessages;
import org.flasck.jvm.container.UpdatesDisplay;
import org.flasck.jvm.fl.FLComparable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.ziwsh.intf.IdempotentHandler;
import org.ziniki.ziwsh.intf.NoContractFound;
import org.ziniki.ziwsh.intf.ProxyForMarshalling;
import org.ziniki.ziwsh.jvm.IdempotentHandlerWithName;
import org.ziniki.ziwsh.jvm.ObjectMarshaller;
import org.zinutils.exceptions.CantHappenException;
import org.zinutils.exceptions.NotImplementedException;
import org.zinutils.exceptions.WrappedException;

public class Send
implements Message,
FLComparable {
    public final Logger logger = LoggerFactory.getLogger((String)"Send");
    public static final Logger tracker = LoggerFactory.getLogger((String)"CallTracker");
    public Object to;
    public Object method;
    public Object args;
    public Object handle;
    public Object subscriptionName;
    public Object subContext;

    private Send(FLEvalContext cxt, Object to, Object method, Object args) {
        this(cxt, to, method, args, null, null);
    }

    private Send(FLEvalContext cxt, Object to, Object method, Object args, Object handle, Object subscriptionName) {
        if (to == null) {
            throw new NotImplementedException();
        }
        this.to = to;
        this.method = method;
        this.args = args;
        this.handle = handle;
        this.subscriptionName = subscriptionName;
        this.subContext = cxt.getSubscriptionContext();
    }

    public static Object eval(FLEvalContext cxt, Object ... args) {
        if (args.length == 3) {
            return new Send(cxt, args[0], args[1], args[2]);
        }
        if (args.length == 5) {
            return new Send(cxt, args[0], args[1], args[2], args[3], args[4]);
        }
        throw new NotImplementedException("Cannot handle " + args.length);
    }

    public void _doFullEval(FLEvalContext cx) {
        this.to = cx.full(this.to);
        this.method = cx.full(this.method);
        this.args = cx.full(this.args);
        this.handle = cx.full(this.handle);
        this.subscriptionName = cx.full(this.subscriptionName);
    }

    @Override
    public boolean equalTo(FLEvalContext cxt, Object other) {
        if (!(other instanceof Send)) {
            return false;
        }
        Send o = (Send)other;
        return cxt.compare(this.to, o.to) && cxt.compare(this.method, o.method) && cxt.compare(this.args, o.args);
    }

    @Override
    public Object dispatch(FLEvalContext cx) {
        this._doFullEval(cx);
        if (this.to instanceof ResponseWithMessages) {
            List<Object> ret = ResponseWithMessages.messages(cx, this.to);
            ret.add(Send.eval(cx, ResponseWithMessages.response(cx, this.to), this.method, this.args, this.handle, this.subscriptionName));
            return ret;
        }
        if (this.to == null) {
            throw new NotImplementedException("can't dispatch null object?");
        }
        if (Proxy.isProxyClass(this.to.getClass())) {
            InvocationHandler invoker = Proxy.getInvocationHandler(this.to);
            if (invoker instanceof NoContractFound) {
                this.logger.info(invoker + " for method " + this.method);
                return null;
            }
            if (invoker instanceof ProxyForMarshalling) {
                ProxyForMarshalling pfm = (ProxyForMarshalling)invoker;
                Method m = pfm.method((String)this.method);
                if (m == null) {
                    return cx.error("there is no method: " + this.method);
                }
                try {
                    tracker.info("<- " + m.getDeclaringClass().getName() + "." + m.getName());
                    cx = this.subContext == null ? cx.bindSubContext(pfm.service()) : cx.bindSubContext(this.subContext);
                    return invoker.invoke(this.to, m, this.addHandler(cx, true, this.args));
                }
                catch (Throwable t) {
                    return cx.error("error sending message: " + t);
                }
            }
            if (invoker instanceof MockContract) {
                if (this.args instanceof Object[]) {
                    this.args = Arrays.asList((Object[])this.args);
                }
                tracker.info("invoking mock " + invoker + "." + this.method);
                return ((MockContract)invoker).dispatch(cx, (String)this.method, (List)this.args, this.handle);
            }
            if (invoker instanceof ObjectMarshaller.BrokerIdemInvoker) {
                try {
                    return invoker.invoke(this.to, this.findMethod(), this.addHandler(cx, true, this.args));
                }
                catch (Throwable e) {
                    throw WrappedException.wrap((Throwable)e);
                }
            }
            throw new NotImplementedException("cannot handle proxy: " + invoker.getClass());
        }
        try {
            Method meth = this.to.getClass().getMethod((String)this.method, FLEvalContext.class, Object[].class);
            tracker.info("calling method " + this.to.getClass().getName() + "." + this.method);
            Object ret = meth.invoke(this.to, cx, this.addHandler(cx, false, this.args));
            if (this.to instanceof UpdatesDisplay) {
                cx.queueMessages(new UpdateDisplay(cx, (UpdatesDisplay)this.to));
            } else if (this.to instanceof ContainsCard) {
                UpdatesDisplay ud = ((ContainsCard)this.to)._card();
                cx.queueMessages(new UpdateDisplay(cx, ud));
            }
            return ret;
        }
        catch (NoSuchMethodException e) {
            this.logger.info("no method " + this.method + " found on " + this.to.getClass().getName());
            return null;
        }
        catch (Exception e) {
            this.logger.error("failed trying to send " + this.method + " to " + this.to.getClass().getName(), (Throwable)e);
            return cx.error("cannot eval " + this.to.getClass().getName() + "." + this.method);
        }
    }

    private Method findMethod() {
        Class<?>[] intfs;
        for (Class<?> i : intfs = this.to.getClass().getInterfaces()) {
            for (Method m : i.getMethods()) {
                if (!m.getName().equals(this.method)) continue;
                return m;
            }
        }
        throw new CantHappenException("there is no method '" + this.method + "' in interfaces for " + this.to.getClass());
    }

    private Object[] addHandler(FLEvalContext cx, boolean useCx, Object args) {
        Object[] as;
        int size = ((Collection)args).size();
        int j = 0;
        if (useCx) {
            as = new Object[size + 2];
            as[j++] = cx;
        } else {
            as = new Object[size + 1];
        }
        for (int i = 0; i < size; ++i) {
            as[j++] = ((List)args).get(i);
        }
        as[j++] = this.handle != null ? new IdempotentHandlerWithName((IdempotentHandler)this.handle, (String)this.subscriptionName) : cx.trivialHandler();
        return as;
    }

    public String toString() {
        return "Send[" + this.to + "." + this.method + "[" + ((List)this.args).size() + "]]";
    }
}

