/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.jvm.builtin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.flasck.jvm.FLEvalContext;
import org.flasck.jvm.builtin.FLError;
import org.flasck.jvm.builtin.Send;
import org.flasck.jvm.container.FLObject;
import org.flasck.jvm.fl.HandlerInfo;
import org.zinutils.exceptions.NotImplementedException;

public class Random
extends FLObject {
    private final List<Object> buffer = new ArrayList<Object>();
    private Xoshiro128 generator;

    private Random(FLEvalContext cx, Object card) {
        super(cx, card);
    }

    public static Object _ctor_seed(FLEvalContext cx, Object ... args) {
        Object card = args[0];
        Random ret = new Random(cx, card);
        Object s1 = cx.full(args[1]);
        if (s1 instanceof FLError) {
            return s1;
        }
        if (!(s1 instanceof Double)) {
            return new FLError("no matching case");
        }
        int seed = (int)((Double)s1).doubleValue();
        ret.generator = new Xoshiro128(-1640531527, 608135816, -1209970334, seed ^ 0xDEADBEEF);
        return ret;
    }

    public Object next(FLEvalContext cx, Object ... args) {
        Object q = args[0];
        if ((q = cx.full(q)) instanceof FLError) {
            return q;
        }
        if (!(q instanceof Double)) {
            return new FLError("No matching case");
        }
        int qu = (int)((Double)q).doubleValue();
        while (this.buffer.size() < qu) {
            this.buffer.add(this.generator.generate());
        }
        return this.buffer;
    }

    public Object used(FLEvalContext cx, Object ... args) {
        return Send.eval(cx, this, "_used", Arrays.asList(args));
    }

    public Object _used(FLEvalContext cx, Object ... args) {
        Object q = args[0];
        if ((q = cx.full(q)) instanceof FLError) {
            return q;
        }
        if (!(q instanceof Double)) {
            return new FLError("No matching case");
        }
        int k = (int)((Double)q).doubleValue();
        while (k-- > 0 && !this.buffer.isEmpty()) {
            this.buffer.remove(0);
        }
        return null;
    }

    @Override
    public String _containedIn() {
        throw new NotImplementedException();
    }

    @Override
    public Map<String, List<HandlerInfo>> _eventHandlers() {
        throw new NotImplementedException();
    }

    private static class Xoshiro128 {
        private int a;
        private int b;
        private int c;
        private int d;

        Xoshiro128(int a, int b, int c, int d) {
            this.a = a;
            this.b = b;
            this.c = c;
            this.d = d;
        }

        static int rotl(int x, int k) {
            return x << k | x >> 32 - k;
        }

        int generate() {
            int result = Xoshiro128.rotl(this.a + this.d, 7) + this.a;
            int t = this.b << 9;
            this.c ^= this.a;
            this.d ^= this.b;
            this.b ^= this.c;
            this.a ^= this.d;
            this.c ^= t;
            this.d = Xoshiro128.rotl(this.d, 11);
            return result & Integer.MAX_VALUE;
        }
    }
}

