/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.jvm.builtin.PACKAGEFUNCTIONS;

import org.flasck.jvm.FLEvalContext;
import org.flasck.jvm.builtin.TypeOf;
import org.ziniki.ziwsh.intf.FieldsContainerWrapper;

public class show {
    public static final int nfargs = 1;

    public static Object eval(FLEvalContext cx, Object ... args) {
        Object obj = cx.full(args[0]);
        return show.doShow(cx, obj, false);
    }

    private static String doShow(FLEvalContext cx, Object obj, boolean wrapMe) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof FieldsContainerWrapper) {
            FieldsContainerWrapper fcw = (FieldsContainerWrapper)obj;
            StringBuilder sb = new StringBuilder();
            if (wrapMe) {
                sb.append("(");
            }
            sb.append((String)fcw.get("_type"));
            fcw.all((k, v) -> {
                sb.append(" ");
                sb.append(show.doShow(cx, v, true));
            });
            if (wrapMe) {
                sb.append(")");
            }
            return sb.toString();
        }
        if (obj instanceof TypeOf) {
            return ((TypeOf)obj).typeName();
        }
        if (obj instanceof Double) {
            Double d = (Double)obj;
            if (d == Math.floor(d) && !d.isInfinite()) {
                return Long.toString((long)d.doubleValue());
            }
            return d.toString();
        }
        if (obj instanceof Class) {
            return ((Class)obj).getName();
        }
        if (obj instanceof String) {
            if (wrapMe) {
                return "\"" + (String)obj + "\"";
            }
            return (String)obj;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj != false ? "True" : "False";
        }
        return obj.toString();
    }
}

