/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.jvm.builtin.PACKAGEFUNCTIONS;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.codehaus.jettison.json.JSONTokener;
import org.flasck.jvm.FLEvalContext;
import org.flasck.jvm.builtin.FLError;

public class parseJson {
    public static final int nfargs = 1;

    public static Object eval(FLEvalContext cx, Object ... args) {
        Object s = cx.full(args[0]);
        if (s instanceof FLError) {
            return s;
        }
        if (!(s instanceof String)) {
            return new FLError("not a string");
        }
        try {
            Object obj = new JSONTokener((String)s).nextValue();
            return parseJson.jsonToObject(obj);
        }
        catch (JSONException e) {
            return new FLError(e.getMessage());
        }
    }

    public static Object jsonToObject(Object obj) throws JSONException {
        if (obj instanceof JSONObject) {
            JSONObject js = (JSONObject)obj;
            TreeMap<String, Object> ret = new TreeMap<String, Object>();
            Iterator ik = js.keys();
            while (ik.hasNext()) {
                String s = (String)ik.next();
                ret.put(s, parseJson.jsonToObject(js.get(s)));
            }
            return ret;
        }
        if (obj instanceof JSONArray) {
            JSONArray ja = (JSONArray)obj;
            ArrayList<Object> ret = new ArrayList<Object>();
            for (int i = 0; i < ja.length(); ++i) {
                ret.add(parseJson.jsonToObject(ja.get(i)));
            }
            return ret;
        }
        return obj;
    }

    public static Object objectToJson(FLEvalContext cx, Object obj) {
        try {
            obj = cx.full(obj);
            if (obj instanceof Map) {
                JSONObject jo = new JSONObject();
                for (Map.Entry e : ((Map)obj).entrySet()) {
                    jo.put((String)e.getKey(), parseJson.objectToJson(cx, e.getValue()));
                }
                return jo;
            }
            if (obj instanceof List) {
                JSONArray ja = new JSONArray();
                for (Object o : (List)obj) {
                    ja.put(parseJson.objectToJson(cx, o));
                }
                return ja;
            }
            return obj;
        }
        catch (JSONException ex) {
            return new FLError(ex.getMessage());
        }
    }

    public static Object objectToJsonString(FLEvalContext cx, Object obj) {
        obj = parseJson.objectToJson(cx, obj);
        return obj.toString();
    }
}

