/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.jvm.builtin;

import java.util.ArrayList;
import java.util.List;
import org.flasck.jvm.FLEvalContext;
import org.flasck.jvm.builtin.Send;
import org.flasck.jvm.fl.Applicable;

public class MakeSend
implements Applicable {
    private final Object onCard;
    private final int required;
    private final List<Object> provided;
    private final String meth;
    public final int nfargs;
    private Object handler;
    private Object subscriptionName;

    private MakeSend(String meth, Object on, int curriedBy, Object handler, Object subscriptionName) {
        this.meth = meth;
        this.onCard = on;
        this.required = curriedBy;
        this.handler = handler;
        this.subscriptionName = subscriptionName;
        this.provided = new ArrayList<Object>();
        this.nfargs = this.required;
    }

    private MakeSend(MakeSend base, List<Object> already) {
        this.meth = base.meth;
        this.onCard = base.onCard;
        this.required = base.required;
        this.handler = base.handler;
        this.subscriptionName = base.subscriptionName;
        this.provided = already;
        this.nfargs = this.required;
    }

    @Override
    public int nfargs() {
        return this.nfargs;
    }

    @Override
    public Object apply(FLEvalContext cx, Object obj, Object[] args) throws Throwable {
        ArrayList<Object> arr = new ArrayList<Object>();
        for (Object o : this.provided) {
            arr.add(o);
        }
        for (Object o : args) {
            arr.add(o);
        }
        if (arr.size() == this.required) {
            return Send.eval(cx, this.onCard, this.meth, arr, this.handler, this.subscriptionName);
        }
        return new MakeSend(this, arr);
    }

    public static Object dot(String meth, Object on, int curry, Object handler, Object subscriptionName) {
        return new MakeSend(meth, on, curry, handler, subscriptionName);
    }

    public String toString() {
        return "MakeSend[" + this.required + "]";
    }
}

