/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.jvm.builtin;

import java.util.ArrayList;
import java.util.Arrays;
import org.flasck.jvm.FLEvalContext;
import org.flasck.jvm.builtin.ActualSlideWindow;
import org.flasck.jvm.builtin.CroEntry;
import org.flasck.jvm.builtin.Crobag;
import org.flasck.jvm.builtin.FLError;
import org.flasck.jvm.builtin.Message;
import org.flasck.jvm.builtin.Send;
import org.flasck.jvm.fl.FLComparable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.ziwsh.intf.NamedIdempotentHandler;
import org.zinutils.exceptions.NotImplementedException;

public class CrobagWindowEvent
implements Message,
FLComparable {
    public final Logger logger = LoggerFactory.getLogger((String)"Send");
    public Object bag;
    public Object from;
    public Object size;
    public Object handle;

    private CrobagWindowEvent(Object to, Object method, Object args, Object handle) {
        if (to == null) {
            throw new NotImplementedException();
        }
        if (handle instanceof NamedIdempotentHandler) {
            System.out.println("NIH found as target");
        }
        this.bag = to;
        this.from = method;
        this.size = args;
        this.handle = handle;
    }

    public static Object eval(FLEvalContext cxt, Object ... args) {
        if (args.length == 4) {
            return new CrobagWindowEvent(args[0], args[1], args[2], args[3]);
        }
        throw new NotImplementedException("Cannot handle " + args.length);
    }

    public void _doFullEval(FLEvalContext cx) {
        this.bag = cx.full(this.bag);
        this.from = cx.full(this.from);
        this.size = cx.full(this.size);
        this.handle = cx.full(this.handle);
    }

    @Override
    public boolean equalTo(FLEvalContext cxt, Object other) {
        if (!(other instanceof CrobagWindowEvent)) {
            return false;
        }
        CrobagWindowEvent o = (CrobagWindowEvent)other;
        return cxt.compare(this.bag, o.bag) && cxt.compare(this.from, o.from) && cxt.compare(this.size, o.size);
    }

    @Override
    public Object dispatch(FLEvalContext cx) {
        this._doFullEval(cx);
        if (this.bag instanceof FLError) {
            return this.bag;
        }
        if (this.from instanceof FLError) {
            return this.from;
        }
        if (this.size instanceof FLError) {
            return this.size;
        }
        if (this.handle instanceof FLError) {
            return this.handle;
        }
        ArrayList<Object> ret = new ArrayList<Object>();
        Crobag crobag = (Crobag)this.bag;
        int sz = (int)((Double)this.size).doubleValue();
        int k = 0;
        for (CroEntry co : crobag.entries) {
            if (co.key.compareTo((String)this.from) < 0) continue;
            if (k >= sz) break;
            ret.add(Send.eval(cx, this.handle, "next", Arrays.asList(co.key, co.val), null, null));
        }
        Object slide = ActualSlideWindow.eval(cx, null, this.bag);
        ret.add(Send.eval(cx, this.handle, "done", new ArrayList(), slide, null));
        return ret;
    }

    public String toString() {
        return "CroWindow[" + this.bag + ", '" + this.from + "' " + this.size + "]";
    }
}

