/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.jvm.builtin;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.flasck.jvm.FLEvalContext;
import org.flasck.jvm.builtin.CroEntry;
import org.flasck.jvm.builtin.CrobagChangeEvent;
import org.flasck.jvm.builtin.CrobagWindowEvent;
import org.flasck.jvm.container.FLObject;
import org.flasck.jvm.container.ResponseWithMessages;
import org.flasck.jvm.fl.HandlerInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.ziwsh.intf.EvalContext;
import org.ziniki.ziwsh.intf.MarshallingTraverser;
import org.ziniki.ziwsh.intf.NamedIdempotentHandler;
import org.ziniki.ziwsh.intf.ObjectMarshalling;
import org.ziniki.ziwsh.intf.Wireable;
import org.ziniki.ziwsh.jvm.ListTraverser;
import org.zinutils.exceptions.CantHappenException;
import org.zinutils.exceptions.NotImplementedException;

public class Crobag
extends FLObject
implements Iterable<CroEntry>,
Wireable {
    public static final Logger logger = LoggerFactory.getLogger((String)"FlasckLib");
    public static int _nfargs_size = 0;
    public static int _nfargs_window = 3;
    Set<CroEntry> entries = new TreeSet<CroEntry>();

    private Crobag(FLEvalContext cx) {
        this(cx, (Object)null);
    }

    private Crobag(FLEvalContext cx, Object card) {
        super(cx, card, "Crobag");
    }

    public static Object _ctor_new(FLEvalContext cx, Object ... args) {
        Object card = args[0];
        Crobag ret = new Crobag(cx, card);
        return new ResponseWithMessages(cx, ret, null);
    }

    public Object insert(FLEvalContext cx, Object ... args) {
        return Arrays.asList(CrobagChangeEvent.eval(cx, this, "insert", args[0], null, args[1]));
    }

    public Object put(FLEvalContext cx, Object ... args) {
        return Arrays.asList(CrobagChangeEvent.eval(cx, this, "put", args[0], null, args[1]));
    }

    public Object upsert(FLEvalContext cx, Object ... args) {
        return Arrays.asList(CrobagChangeEvent.eval(cx, this, "upsert", args[0], null, args[1]));
    }

    public Object size(FLEvalContext cx, Object ... args) {
        return (double)this.entries.size();
    }

    public Object window(FLEvalContext cx, Object ... args) {
        if (args.length != 3) {
            throw new CantHappenException("expected 2 args and a handler, not " + Arrays.asList(args));
        }
        Object h = args[2];
        if (h instanceof NamedIdempotentHandler) {
            h = ((NamedIdempotentHandler)h).handler();
        }
        return Arrays.asList(CrobagWindowEvent.eval(cx, this, args[0], args[1], h));
    }

    @Override
    public String _containedIn() {
        throw new NotImplementedException();
    }

    @Override
    public Map<String, List<HandlerInfo>> _eventHandlers() {
        throw new NotImplementedException();
    }

    public void _change(FLEvalContext cx, String op, String addkey, String removekey, Object val) {
        if (removekey != null) {
            throw new NotImplementedException();
        }
        if (addkey != null) {
            CroEntry e = new CroEntry(addkey, val);
            if (this.entries.contains(e)) {
                switch (op) {
                    case "put": {
                        this.entries.remove(e);
                        break;
                    }
                    default: {
                        throw new NotImplementedException("the semantics for '" + op + "' are not yet supported");
                    }
                }
            }
            this.entries.add(e);
        }
    }

    @Override
    public Iterator<CroEntry> iterator() {
        return this.entries.iterator();
    }

    public String toString() {
        return "Crobag[" + this.id() + ":" + this.entries.size() + "]";
    }

    public Map<String, Object> fields() throws IOException {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("entries", this.entries);
        return ret;
    }

    public static Crobag fromWire(FLEvalContext cx, ObjectMarshalling om, Map<String, Object> args) {
        Crobag ret = new Crobag(cx, (Object)null);
        Collection os = (Collection)args.get("entries");
        if (!os.isEmpty()) {
            ListTraverser inner = new ListTraverser((EvalContext)cx, om.state());
            for (Object e : os) {
                try {
                    om.marshal((EvalContext)cx, (MarshallingTraverser)inner, e);
                }
                catch (ClassNotFoundException ex) {
                    logger.error("failed to unpack crobag", (Throwable)ex);
                }
            }
            for (CroEntry o : inner.asList()) {
                ret._change(cx, "put", o.key, null, o.val);
            }
        }
        return ret;
    }
}

