/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.jvm.builtin;

import java.util.ArrayList;
import java.util.List;
import org.flasck.jvm.FLEvalContext;
import org.flasck.jvm.builtin.FLError;

public class Cons {
    public static final int nfargs = 2;
    private final Object list;

    private Cons(Object obj) {
        this.list = obj;
    }

    public Object _field_head(FLEvalContext cx, Object ... args) {
        Object l = cx.head(this.list);
        if (l instanceof FLError) {
            return l;
        }
        if (l instanceof List) {
            List ll = (List)l;
            if (ll.isEmpty()) {
                return new FLError("should be a non-empty list");
            }
            return ll.get(0);
        }
        return new FLError("not a list");
    }

    public Object _field_tail(FLEvalContext cx, Object ... args) {
        Object l = cx.head(this.list);
        if (l instanceof FLError) {
            return l;
        }
        if (l instanceof List) {
            List ll = (List)l;
            if (ll.isEmpty()) {
                return new FLError("should be a non-empty list");
            }
            ArrayList ret = new ArrayList(ll);
            ret.remove(0);
            return ret;
        }
        return new FLError("not a list");
    }

    public static Object eval(FLEvalContext cxt, Object ... args) {
        Object tail = cxt.head(args[1]);
        if (tail instanceof FLError) {
            return args[1];
        }
        ArrayList<Object> ret = tail == null ? new ArrayList<Object>() : new ArrayList((List)tail);
        ret.add(0, args[0]);
        return ret;
    }

    public static Object wrap(Object obj) {
        return new Cons(obj);
    }
}

