/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.jvm.builtin;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.flasck.jvm.FLEvalContext;
import org.flasck.jvm.builtin.Date;
import org.flasck.jvm.builtin.FLError;
import org.flasck.jvm.builtin.Instant;
import org.flasck.jvm.container.FLObject;
import org.flasck.jvm.container.ResponseWithMessages;
import org.flasck.jvm.fl.HandlerInfo;
import org.zinutils.exceptions.NotImplementedException;

public class Calendar
extends FLObject {
    public static int _nfargs_isoDateTime = 1;
    private TimeZone tz = TimeZone.getTimeZone("UTC");

    private Calendar(FLEvalContext cx, Object card) {
        super(cx, card);
    }

    public static Object _ctor_gregorian(FLEvalContext cx, Object ... args) {
        Object card = args[0];
        Calendar ret = new Calendar(cx, card);
        return new ResponseWithMessages(cx, ret, null);
    }

    public Object isoDateTime(FLEvalContext cx, Object ... args) {
        Object inst = cx.full(args[0]);
        if (inst instanceof FLError) {
            return inst;
        }
        if (!(inst instanceof Instant)) {
            return "not an instant";
        }
        Instant i = (Instant)inst;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        sdf.setTimeZone(this.tz);
        return sdf.format(i.asJava());
    }

    public Object parseIsoDate(FLEvalContext cx, Object ... args) {
        Object s = cx.full(args[0]);
        if (s instanceof FLError) {
            return s;
        }
        if (!(s instanceof String)) {
            return "not a string";
        }
        String date = (String)s;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        sdf.setTimeZone(this.tz);
        try {
            java.util.Date dt = sdf.parse(date);
            SimpleDateFormat toInt = new SimpleDateFormat("yyyyMMdd");
            toInt.setTimeZone(this.tz);
            return new Date(Integer.parseInt(toInt.format(dt)));
        }
        catch (NumberFormatException | ParseException ex) {
            return new FLError("cannot parse date: '" + date + "'");
        }
    }

    @Override
    public String _containedIn() {
        throw new NotImplementedException();
    }

    @Override
    public Map<String, List<HandlerInfo>> _eventHandlers() {
        throw new NotImplementedException();
    }
}

