/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.jvm.builtin;

import java.util.ArrayList;
import java.util.List;
import org.flasck.jvm.FLEvalContext;
import org.flasck.jvm.builtin.AssignItem;
import org.flasck.jvm.builtin.FLError;
import org.flasck.jvm.builtin.Message;
import org.flasck.jvm.container.ResponseWithMessages;
import org.flasck.jvm.fl.FLComparable;
import org.zinutils.exceptions.CantHappenException;

public class AssignCons
implements Message,
FLComparable {
    public Object target;
    public Object value;
    public static final int nfargs = 2;

    private AssignCons(Object card, Object value) {
        this.target = card;
        this.value = value;
    }

    public static Object eval(FLEvalContext cxt, Object ... args) {
        return new AssignCons(args[0], args[1]);
    }

    public void _doFullEval(FLEvalContext cx) {
        this.target = cx.full(this.target);
        this.value = cx.full(this.value);
    }

    @Override
    public boolean equalTo(FLEvalContext cxt, Object other) {
        if (!(other instanceof AssignCons)) {
            return false;
        }
        AssignCons o = (AssignCons)other;
        return cxt.compare(this.target, o.target) && cxt.compare(this.value, o.value);
    }

    @Override
    public Object dispatch(FLEvalContext cx) {
        this._doFullEval(cx);
        ArrayList<List<Object>> msgs = new ArrayList<List<Object>>();
        Object dest = this.target;
        if (this.target instanceof Message && ((dest = ((Message)this.target).dispatch(cx)) instanceof FLError || dest == null)) {
            return dest;
        }
        if (!(dest instanceof AssignItem)) {
            throw new CantHappenException("AssignCons requires an AssignItem");
        }
        if (this.value instanceof ResponseWithMessages) {
            msgs.add(0, ResponseWithMessages.messages(cx, this.value));
            this.value = ResponseWithMessages.response(cx, this.value);
        }
        ((AssignItem)dest).set(this.value);
        return msgs;
    }

    public String toString() {
        return "AssignCons[" + this.target + " <- " + this.value + "]";
    }
}

