/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.jvm.builtin;

import java.util.ArrayList;
import org.flasck.jvm.FLEvalContext;
import org.flasck.jvm.builtin.ContainsCard;
import org.flasck.jvm.builtin.FLError;
import org.flasck.jvm.builtin.Message;
import org.flasck.jvm.builtin.UpdateDisplay;
import org.flasck.jvm.container.ResponseWithMessages;
import org.flasck.jvm.container.UpdatesDisplay;
import org.flasck.jvm.fl.FLComparable;
import org.flasck.jvm.fl.JVMFieldsContainerWrapper;

public class Assign
implements Message,
FLComparable {
    public Object target;
    public Object field;
    public Object value;
    public static final int nfargs = 3;

    private Assign(Object card, Object field, Object value) {
        this.target = card;
        this.field = field;
        this.value = value;
    }

    public static Object eval(FLEvalContext cxt, Object ... args) {
        return new Assign(args[0], args[1], args[2]);
    }

    public void _doFullEval(FLEvalContext cx) {
        this.target = cx.full(this.target);
        this.field = cx.full(this.field);
        this.value = cx.full(this.value);
    }

    @Override
    public boolean equalTo(FLEvalContext cxt, Object other) {
        if (!(other instanceof Assign)) {
            return false;
        }
        Assign o = (Assign)other;
        return cxt.compare(this.target, o.target) && cxt.compare(this.field, o.field) && cxt.compare(this.value, o.value);
    }

    @Override
    public Object dispatch(FLEvalContext cx) {
        this._doFullEval(cx);
        ArrayList<Object> msgs = new ArrayList<Object>();
        Object dest = this.target;
        if (this.target instanceof Message && ((dest = ((Message)this.target).dispatch(cx)) instanceof FLError || dest == null)) {
            return dest;
        }
        if (this.value instanceof ResponseWithMessages) {
            msgs.add(0, ResponseWithMessages.messages(cx, this.value));
            this.value = ResponseWithMessages.response(cx, this.value);
        }
        ((JVMFieldsContainerWrapper)dest).set((String)this.field, this.value);
        if (dest instanceof UpdatesDisplay) {
            msgs.add(new UpdateDisplay(cx, (UpdatesDisplay)dest));
        } else if (dest instanceof ContainsCard) {
            msgs.add(new UpdateDisplay(cx, ((ContainsCard)dest)._card()));
        }
        return msgs;
    }

    public String toString() {
        return "Assign[" + this.target + "." + this.field + " <- " + this.value + "]";
    }
}

