/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.jvm.assembly;

import java.io.File;
import org.flasck.jvm.assembly.Activatable;
import org.flasck.jvm.assembly.ApplicationAssembly;
import org.flasck.jvm.assembly.CardInitializer;
import org.flasck.jvm.assembly.VisitingPackageInfo;
import org.flasck.jvm.assembly.WaitAMo;
import org.flasck.jvm.ziniki.ContentObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FlasckAssembler
implements VisitingPackageInfo {
    protected static final Logger logger = LoggerFactory.getLogger((String)"assembler");
    protected Activatable traverser;
    private final boolean useCachebuster;
    private boolean firstMap;

    public FlasckAssembler(boolean usecb) {
        this.useCachebuster = usecb;
    }

    public void includeJS(File file) {
        logger.info("including JS " + file);
    }

    public void assemble(String appname, ApplicationAssembly source) throws Exception {
        this.traverser = source.visitAsync(appname, this);
        this.traverser.activate();
    }

    @Override
    public WaitAMo begin() {
        this.writeHTML("<!DOCTYPE html>\n<html>\n  <head>\n    <title>");
        return WaitAMo.CONTINUE;
    }

    @Override
    public WaitAMo title(String title) {
        if (title != null) {
            return this.writeHTML(title);
        }
        return WaitAMo.CONTINUE;
    }

    @Override
    public WaitAMo afterTitle() {
        return this.writeHTML("</title>\n    <meta name=\"viewport\" content=\"width=device-width,initial-scale=1,maximum-scale=1,user-scalable=no\">\n    <meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge,chrome=1\">\n    <meta name=\"HandheldFriendly\" content=\"true\">\n");
    }

    @Override
    public WaitAMo templates(ContentObject co) {
        return this.writeHTML(co.asString());
    }

    @Override
    public WaitAMo beginCss() {
        return WaitAMo.CONTINUE;
    }

    @Override
    public WaitAMo css(String includeCss) {
        String file = includeCss;
        return this.writeHTML("    <link rel='stylesheet' type='text/css' href='" + file + "'>\n");
    }

    @Override
    public WaitAMo endCss() {
        return WaitAMo.CONTINUE;
    }

    @Override
    public WaitAMo beginJs() {
        return WaitAMo.CONTINUE;
    }

    @Override
    public WaitAMo javascript(String path) {
        if (this.useCachebuster) {
            path = (String)path + "?cachebuster=" + System.currentTimeMillis();
        }
        return this.writeHTML("    <script type='module' src='" + (String)path + "' charset='UTF-8'></script>\n");
    }

    @Override
    public WaitAMo endJs() {
        return WaitAMo.CONTINUE;
    }

    public WaitAMo endHead() {
        return this.writeHTML("  </head>\n");
    }

    @Override
    public WaitAMo beginImportMap() {
        this.firstMap = true;
        return this.writeHTML("    <script type='importmap'>\n    {\n       \"imports\": {\n");
    }

    @Override
    public WaitAMo mapJavascript(String called, String actual) {
        String s = this.firstMap ? "" : ",\n";
        this.firstMap = false;
        return this.writeHTML(s + "          \"" + called + "\": \"" + actual + "\"");
    }

    @Override
    public WaitAMo endImportMap() {
        return this.writeHTML("\n       }\n    }\n    </script>\n");
    }

    @Override
    public WaitAMo beginInit() {
        return this.writeHTML("  <body>\n");
    }

    @Override
    public WaitAMo initializer(CardInitializer init) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<div id='flaselt_root'></div>\n");
        buffer.append("<script type='module'>\n");
        buffer.append("  import { JSEnv } from \"/js/flaslive.js\";\n");
        buffer.append("  const env = new JSEnv();\n");
        this.provideServerAddress(buffer);
        buffer.append("  const cx = env.newContext();\n");
        for (String pkg : init.packages()) {
            String pn = pkg.replace(".", "__");
            buffer.append("  import { " + pn + " } from \"/js/" + pkg + ".js\";\n");
            buffer.append("  " + pn + "._init(cx);\n");
        }
        buffer.append("  env.makeReady();\n");
        buffer.append("  var appl = new " + init.packageName().replace(".", "__") + "._Application(cx, 'flaselt_root');\n");
        this.handleSecurityModule(buffer);
        buffer.append("  appl.gotoRoute(cx, window.location);\n");
        buffer.append("</script>");
        return this.writeHTML(buffer.toString());
    }

    @Override
    public WaitAMo endInit() {
        return WaitAMo.CONTINUE;
    }

    @Override
    public WaitAMo end() {
        return this.writeHTML("\n  </body>\n</html>");
    }

    protected abstract WaitAMo writeHTML(String var1);

    protected abstract void provideServerAddress(StringBuilder var1);

    protected abstract void handleSecurityModule(StringBuilder var1);
}

