/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.tokenizers;

import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.grammar.tracking.LoggableToken;
import org.flasck.flas.tokenizers.Tokenizable;

public class ValidIdentifierToken
implements LoggableToken {
    public final InputPosition location;
    public final String text;

    public ValidIdentifierToken(InputPosition pos, String text, int end) {
        this.location = pos;
        this.location.endAt(end);
        this.text = text;
    }

    public static ValidIdentifierToken from(ErrorReporter errors, Tokenizable line) {
        line.skipWS(errors);
        int mark = line.at();
        InputPosition pos = line.realinfo();
        if (!line.hasMore() || !ValidIdentifierToken.isIdentifierStart(line.nextChar())) {
            return null;
        }
        line.advance();
        while (line.hasMore() && ValidIdentifierToken.isIdentifierPart(line.nextChar())) {
            line.advance();
        }
        return errors.logParsingToken(new ValidIdentifierToken(pos, line.fromMark(mark), line.at() - 1));
    }

    private static boolean isIdentifierStart(char c) {
        return Character.isLetter(c) || c == '_';
    }

    private static boolean isIdentifierPart(char c) {
        return Character.isLetter(c) || Character.isDigit(c) || c == '_';
    }

    public String toString() {
        return "VIT[" + this.text + ":" + this.location + "]";
    }

    @Override
    public InputPosition location() {
        return this.location;
    }

    @Override
    public String type() {
        return "var-name";
    }

    @Override
    public String text() {
        return this.text;
    }
}

