/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.tokenizers;

import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.grammar.tracking.LoggableToken;
import org.flasck.flas.tokenizers.Tokenizable;
import org.flasck.flas.tokenizers.ValidIdentifierToken;

public class TypeNameToken
implements LoggableToken {
    public final InputPosition location;
    public final String text;

    public TypeNameToken(ValidIdentifierToken tok) {
        this.location = tok.location;
        this.text = tok.text;
    }

    public TypeNameToken(InputPosition loc, String proto, int end) {
        this.location = loc;
        this.location.endAt(end);
        this.text = proto;
    }

    public static TypeNameToken unqualified(ErrorReporter errors, Tokenizable line) {
        line.skipWS(errors);
        if (!line.hasMore()) {
            return null;
        }
        int mark = line.at();
        char c = line.nextChar();
        if (!Character.isUpperCase(c)) {
            line.reset(mark);
            return null;
        }
        ValidIdentifierToken tok = ValidIdentifierToken.from(errors, line);
        if (tok.text.length() == 1 || tok.text.length() == 2 && (Character.isUpperCase(tok.text.charAt(1)) || Character.isDigit(tok.text.charAt(1)))) {
            line.reset(mark);
            return null;
        }
        return errors.logParsingToken(new TypeNameToken(tok));
    }

    public static TypeNameToken qualified(ErrorReporter errors, Tokenizable line) {
        line.skipWS(errors);
        if (!line.hasMore() || !Character.isJavaIdentifierStart(line.nextChar())) {
            return null;
        }
        InputPosition loc = line.realinfo();
        int mark = line.at();
        boolean isNameStart = true;
        boolean haveName = false;
        while (line.hasMore()) {
            if (Character.isJavaIdentifierPart(line.nextChar())) {
                if (isNameStart && Character.isUpperCase(line.nextChar())) {
                    haveName = true;
                }
                isNameStart = false;
            } else {
                if (line.nextChar() != '.' || haveName) break;
                isNameStart = true;
            }
            line.advance();
        }
        if (haveName) {
            return errors.logParsingToken(new TypeNameToken(loc, line.fromMark(mark), line.at()));
        }
        line.reset(mark);
        return null;
    }

    @Override
    public InputPosition location() {
        return this.location;
    }

    @Override
    public String type() {
        return "type-name";
    }

    @Override
    public String text() {
        return this.text;
    }

    public String toString() {
        return "TNT[" + this.text + "]";
    }
}

