/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.tokenizers;

import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.grammar.tracking.LoggableToken;
import org.flasck.flas.tokenizers.Tokenizable;
import org.flasck.flas.tokenizers.TypeNameToken;

public class TypeExprToken
implements LoggableToken {
    public static final int NAME = 1;
    public static final int ORB = 10;
    public static final int CRB = 11;
    public static final int OSB = 12;
    public static final int CSB = 13;
    public static final int COMMA = 14;
    public static final int ARROW = 15;
    public final InputPosition location;
    public final int type;
    public final String text;

    public TypeExprToken(InputPosition location, int type, String text, int end) {
        this.location = location;
        this.location.endAt(end);
        this.type = type;
        this.text = text;
    }

    public static TypeExprToken from(ErrorReporter errors, Tokenizable line) {
        line.skipWS(errors);
        if (!line.hasMore()) {
            return null;
        }
        InputPosition loc = line.realinfo();
        char c = line.nextChar();
        if (Character.isLetter(c)) {
            TypeNameToken tmp = TypeNameToken.qualified(errors, line);
            if (tmp != null) {
                return errors.logParsingToken(new TypeExprToken(loc, 1, tmp.text, line.at()));
            }
            return null;
        }
        int pos = "()[],".indexOf(c);
        if (pos != -1) {
            line.advance();
            return errors.logParsingToken(new TypeExprToken(loc, 10 + pos, new String(new char[]{c}), line.at()));
        }
        if ("->".equals(line.getTo(2))) {
            return errors.logParsingToken(new TypeExprToken(loc, 15, "->", line.at()));
        }
        return null;
    }

    public String toString() {
        return "PT[" + this.type + ":" + this.text + "]";
    }

    @Override
    public InputPosition location() {
        return this.location;
    }

    @Override
    public String type() {
        switch (this.type) {
            case 1: {
                return "type-name";
            }
            case 10: {
                return "ORB";
            }
            case 11: {
                return "CRB";
            }
            case 12: {
                return "OSB";
            }
            case 13: {
                return "CSB";
            }
            case 14: {
                return "COMMA";
            }
            case 15: {
                return "ARROW";
            }
        }
        return "TypeExprToken_" + this.type;
    }

    @Override
    public String text() {
        return this.text;
    }
}

