/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.tokenizers;

import org.flasck.flas.blockForm.ContinuedLine;
import org.flasck.flas.blockForm.Indent;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.blockForm.SingleLine;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.errors.ErrorResult;
import org.flasck.flas.tokenizers.CommentToken;
import org.flasck.flas.tokenizers.StringToken;

public class Tokenizable {
    private final ContinuedLine line;
    private final StringBuilder input;
    private int pos;

    public Tokenizable(ContinuedLine l) {
        if (l == null) {
            this.input = null;
            this.line = null;
            return;
        }
        this.input = l.text();
        this.line = l;
    }

    public Tokenizable(ContinuedLine l, StringBuilder in, int pos) {
        this.line = l;
        this.input = in;
        this.pos = pos;
    }

    public Tokenizable(String input) {
        this.input = new StringBuilder(input);
        this.pos = 0;
        this.line = new ContinuedLine();
        this.line.lines.add(new SingleLine("test", 1, new Indent(1, 0), input));
    }

    public int at() {
        return this.pos;
    }

    public void skipWS(ErrorReporter errors) {
        while (this.pos < this.input.length() && Character.isWhitespace(this.input.charAt(this.pos))) {
            ++this.pos;
        }
        if (this.pos + 1 < this.input.length() && this.input.charAt(this.pos) == '/' && this.input.charAt(this.pos + 1) == '/') {
            InputPosition loc = this.realinfo();
            int at = this.pos;
            int idx = this.input.indexOf("\n", this.pos);
            this.pos = idx == -1 ? this.input.length() : idx + 1;
            errors.logParsingToken(new CommentToken(loc, this.input.substring(at, this.pos).trim()));
        }
    }

    public boolean still(int i) {
        return this.pos + i < this.input.length();
    }

    public boolean hasMore() {
        return this.pos < this.input.length();
    }

    public boolean hasMoreContent(ErrorReporter errors) {
        this.skipWS(errors);
        return this.pos < this.input.length();
    }

    public char nextChar() {
        return this.input.charAt(this.pos);
    }

    public char charAt(int i) {
        return this.input.charAt(this.pos + i);
    }

    public void advance() {
        ++this.pos;
    }

    public String fromMark(int mark) {
        if (this.pos <= mark) {
            return null;
        }
        return this.input.substring(mark, this.pos);
    }

    public String remainder() {
        return this.input.substring(this.pos, this.input.length());
    }

    public String getTo(int length) {
        if (this.pos + length > this.input.length()) {
            length = this.input.length() - this.pos;
        }
        if (length <= 0) {
            return null;
        }
        String ret = this.input.substring(this.pos, this.pos + length);
        this.pos += length;
        return ret;
    }

    public void reset(int mark) {
        this.pos = mark;
    }

    public InputPosition realinfo() {
        if (this.line == null) {
            return null;
        }
        return this.line.locationAtText(this.pos);
    }

    public InputPosition locationAtText(int i) {
        if (this.line == null) {
            return null;
        }
        return this.line.locationAtText(i);
    }

    public String toString() {
        return "Tkz[" + this.input.substring(0, this.pos) + "__" + this.input.substring(this.pos) + "]";
    }

    public int length() {
        return this.input.length();
    }

    public int actualLine() {
        return this.line.actualLine(this.pos);
    }

    public int find(String sub) {
        ErrorResult tmp = new ErrorResult();
        int init = this.pos;
        for (int i = this.pos; i < this.input.length(); ++i) {
            if (this.input.substring(i).startsWith("//")) {
                return -1;
            }
            if (this.input.charAt(i) == '\"' || this.input.charAt(i) == '\'') {
                this.pos = i;
                StringToken.from(tmp, this);
                i = this.pos;
                this.pos = init;
            }
            if (!this.input.substring(i).startsWith(sub)) continue;
            return i;
        }
        return -1;
    }

    public Tokenizable cropAt(int k) {
        StringBuilder in2 = new StringBuilder(this.input.substring(0, k));
        return new Tokenizable(this.line, in2, this.pos);
    }

    public Tokenizable copyTo(String string) {
        int k = this.find("->");
        if (k == -1) {
            return this;
        }
        return this.cropAt(k);
    }
}

