/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.tokenizers;

import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.grammar.tracking.LoggableToken;
import org.flasck.flas.tokenizers.Tokenizable;

public class PuncToken
implements LoggableToken {
    public final InputPosition location;
    public final String text;

    public PuncToken(InputPosition location, String text) {
        this.location = location;
        this.text = text;
    }

    public static PuncToken from(ErrorReporter errors, Tokenizable line) {
        line.skipWS(errors);
        if (!line.hasMore()) {
            return null;
        }
        InputPosition loc = line.realinfo();
        int mark = line.at();
        char c = line.nextChar();
        if ("()[]{}.,:".indexOf(c) != -1) {
            line.advance();
            return errors.logParsingToken(new PuncToken(loc.copySetEnd(line.at()), line.fromMark(mark)));
        }
        line.reset(mark);
        return null;
    }

    public String toString() {
        return "PT[" + this.text + "]";
    }

    @Override
    public InputPosition location() {
        return this.location;
    }

    @Override
    public String type() {
        return "Punctoken";
    }

    @Override
    public String text() {
        return this.text;
    }
}

