/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.tokenizers;

import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.grammar.tracking.LoggableToken;
import org.flasck.flas.tokenizers.NumberToken;
import org.flasck.flas.tokenizers.StringToken;
import org.flasck.flas.tokenizers.Tokenizable;
import org.flasck.flas.tokenizers.ValidIdentifierToken;

public class PattToken
implements LoggableToken {
    public static final int VAR = 1;
    public static final int TYPE = 2;
    public static final int NUMBER = 3;
    public static final int STRING = 4;
    public static final int TRUE = 5;
    public static final int FALSE = 6;
    public static final int ORB = 10;
    public static final int CRB = 11;
    public static final int OSB = 12;
    public static final int CSB = 13;
    public static final int OCB = 14;
    public static final int CCB = 15;
    public static final int COLON = 16;
    public static final int COMMA = 17;
    public final InputPosition location;
    public final int type;
    public final String text;
    private String original;

    public PattToken(InputPosition loc, int type, String text, int end) {
        this.location = loc;
        this.location.endAt(end);
        this.type = type;
        this.text = text;
    }

    public static PattToken from(ErrorReporter errors, Tokenizable line) {
        line.skipWS(errors);
        if (!line.hasMore()) {
            return null;
        }
        char c = line.nextChar();
        if (Character.isJavaIdentifierStart(c)) {
            ValidIdentifierToken tok = ValidIdentifierToken.from(errors, line);
            if (tok == null) {
                return null;
            }
            if (tok.text.equals("true")) {
                return errors.logParsingToken(new PattToken(tok.location, 5, "true", line.at()));
            }
            if (tok.text.equals("false")) {
                return errors.logParsingToken(new PattToken(tok.location, 6, "false", line.at()));
            }
            return errors.logParsingToken(new PattToken(tok.location, Character.isUpperCase(c) ? 2 : 1, tok.text, line.at()));
        }
        if (c == '\"' || c == '\'') {
            InputPosition loc = line.realinfo();
            int at = line.at();
            String s = StringToken.from(errors, line);
            return errors.logParsingToken(new PattToken(loc, 4, s, line.at()).original(line.fromMark(at)));
        }
        if (Character.isDigit(c) || c == '.' && line.still(1) && Character.isDigit(line.charAt(1))) {
            NumberToken num = NumberToken.from(errors, line);
            return errors.logParsingToken(new PattToken(num.location, 3, num.text, line.at()));
        }
        int pos = "()[]{}:,".indexOf(c);
        if (pos != -1) {
            InputPosition loc = line.realinfo();
            line.advance();
            return errors.logParsingToken(new PattToken(loc, pos + 10, new String(new char[]{c}), line.at()));
        }
        return null;
    }

    private PattToken original(String o) {
        this.original = o;
        return this;
    }

    public String toString() {
        return "PT[" + this.type + ":" + this.text + "]";
    }

    @Override
    public InputPosition location() {
        return this.location;
    }

    @Override
    public String type() {
        switch (this.type) {
            case 1: {
                return "var-name";
            }
            case 3: {
                return "NUMBER";
            }
            case 4: {
                return "STRING";
            }
            case 10: {
                return "ORB";
            }
            case 11: {
                return "CRB";
            }
            case 12: {
                return "OSB";
            }
            case 13: {
                return "CSB";
            }
            case 14: {
                return "OCB";
            }
            case 15: {
                return "CCB";
            }
            case 16: {
                return "COLON";
            }
            case 17: {
                return "COMMA";
            }
        }
        return "Patt_" + this.type;
    }

    @Override
    public String text() {
        if (this.original != null) {
            return this.original;
        }
        return this.text;
    }
}

