/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.tokenizers;

import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.tokenizers.Tokenizable;
import org.flasck.flas.tokenizers.ValidIdentifierToken;

public class PackageNameToken {
    public final InputPosition location;
    public final String text;

    public PackageNameToken(ValidIdentifierToken tok) {
        this.location = tok.location;
        this.text = tok.text;
    }

    public PackageNameToken(InputPosition loc, String proto, int end) {
        this.location = loc;
        this.location.endAt(end);
        this.text = proto;
    }

    public static PackageNameToken from(ErrorReporter errors, Tokenizable line) {
        line.skipWS(errors);
        if (!line.hasMore() || !Character.isJavaIdentifierStart(line.nextChar())) {
            return null;
        }
        InputPosition loc = line.realinfo();
        int mark = line.at();
        line.advance();
        while (line.hasMore() && (Character.isJavaIdentifierPart(line.nextChar()) || line.nextChar() == '.')) {
            line.advance();
        }
        return new PackageNameToken(loc, line.fromMark(mark), line.at());
    }
}

