/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.tokenizers;

import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.tokenizers.Tokenizable;

public class NumberToken {
    public final InputPosition location;
    public final String text;

    public NumberToken(InputPosition pos, String text, int end) {
        this.location = pos;
        this.location.endAt(end);
        this.text = text;
    }

    public static NumberToken from(ErrorReporter errors, Tokenizable line) {
        line.skipWS(errors);
        int mark = line.at();
        InputPosition pos = line.realinfo();
        while (line.hasMore() && Character.isDigit(line.nextChar())) {
            line.advance();
        }
        if (line.hasMore() && line.nextChar() == '.') {
            line.advance();
            while (line.hasMore() && Character.isDigit(line.nextChar())) {
                line.advance();
            }
        }
        int m1 = line.at();
        if (line.hasMore() && line.nextChar() == 'e') {
            line.advance();
            if (line.hasMore() && line.nextChar() == '-') {
                line.advance();
            }
            if (!line.hasMore() || !Character.isDigit(line.nextChar())) {
                return new NumberToken(pos, line.fromMark(mark), m1);
            }
            while (line.hasMore() && Character.isDigit(line.nextChar())) {
                line.advance();
            }
        }
        return new NumberToken(pos, line.fromMark(mark), line.at() - 1);
    }
}

