/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.tokenizers;

import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.grammar.tracking.LoggableToken;
import org.flasck.flas.tokenizers.Tokenizable;
import org.flasck.flas.tokenizers.ValidIdentifierToken;

public class MessageToken
implements LoggableToken {
    public static final int IDENTIFIER = 1;
    public static final int DOT = 2;
    public static final int ARROW = 3;
    public final InputPosition location;
    public final int type;
    public final String text;

    public MessageToken(InputPosition loc, int type, String text, int end) {
        this.location = loc;
        this.location.endAt(end);
        this.type = type;
        this.text = text;
    }

    public static MessageToken from(ErrorReporter errors, Tokenizable line) {
        line.skipWS(errors);
        if (!line.hasMore()) {
            return null;
        }
        InputPosition loc = line.realinfo();
        char c = line.nextChar();
        if (Character.isJavaIdentifierStart(c)) {
            return errors.logParsingToken(new MessageToken(loc, 1, ValidIdentifierToken.from((ErrorReporter)errors, (Tokenizable)line).text, line.at()));
        }
        if (c == '.') {
            line.advance();
            return errors.logParsingToken(new MessageToken(loc, 2, ".", line.at()));
        }
        if ("<-".equals(line.getTo(2))) {
            return errors.logParsingToken(new MessageToken(loc, 3, "<-", line.at()));
        }
        return null;
    }

    public String toString() {
        return "MT[" + this.type + ":" + this.text + "]";
    }

    @Override
    public InputPosition location() {
        return this.location;
    }

    @Override
    public String type() {
        return "Message_" + this.type;
    }

    @Override
    public String text() {
        return this.text;
    }
}

