/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.tokenizers;

import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.grammar.tracking.LoggableToken;
import org.flasck.flas.tokenizers.NumberToken;
import org.flasck.flas.tokenizers.StringToken;
import org.flasck.flas.tokenizers.Tokenizable;
import org.flasck.flas.tokenizers.ValidIdentifierToken;

public class ExprToken
implements LoggableToken {
    public static final int IDENTIFIER = 1;
    public static final int NUMBER = 2;
    public static final int PUNC = 3;
    public static final int SYMBOL = 4;
    public static final int STRING = 5;
    public final InputPosition location;
    public final int type;
    public final String text;
    private String original;

    public ExprToken(InputPosition location, int type, String text) {
        this.location = location;
        this.type = type;
        this.text = text;
    }

    public ExprToken(int type, ValidIdentifierToken vit) {
        this.location = vit.location;
        this.type = type;
        this.text = vit.text;
    }

    public ExprToken(int type, NumberToken from) {
        this.location = from.location;
        this.type = type;
        this.text = from.text;
    }

    @Override
    public InputPosition location() {
        return this.location;
    }

    @Override
    public String type() {
        switch (this.type) {
            case 1: {
                return "var-name";
            }
            case 2: {
                return "NUMBER";
            }
            case 3: {
                switch (this.text) {
                    case "(": {
                        return "ORB";
                    }
                    case ")": {
                        return "CRB";
                    }
                    case ",": {
                        return "COMMA";
                    }
                    case ".": {
                        return "APPLY";
                    }
                }
                return "PUNC";
            }
            case 4: {
                return "symbol";
            }
            case 5: {
                return "STRING";
            }
        }
        return "ExprToken_" + this.type;
    }

    @Override
    public String text() {
        if (this.original != null) {
            return this.original;
        }
        return this.text;
    }

    public static ExprToken from(ErrorReporter errors, Tokenizable line) {
        line.skipWS(errors);
        if (!line.hasMore()) {
            return null;
        }
        InputPosition loc = line.realinfo();
        int mark = line.at();
        char c = line.nextChar();
        if (Character.isJavaIdentifierStart(c)) {
            return errors.logParsingToken(new ExprToken(1, ValidIdentifierToken.from(errors, line)));
        }
        if (c == '\"' || c == '\'') {
            String tok = StringToken.from(errors, line);
            if (tok == null) {
                return null;
            }
            return errors.logParsingToken(new ExprToken(loc.copySetEnd(line.at() - 1), 5, tok).original(line.fromMark(mark)));
        }
        if (Character.isDigit(c) || c == '.' && line.still(1) && Character.isDigit(line.charAt(1))) {
            return errors.logParsingToken(new ExprToken(2, NumberToken.from(errors, line)));
        }
        if ("()[]{}.,:".indexOf(c) != -1) {
            line.advance();
            return errors.logParsingToken(new ExprToken(loc.copySetEnd(line.at() - 1), 3, line.fromMark(mark)));
        }
        while (line.hasMore() && "~!$%^&|*/+-=:<>".indexOf(line.nextChar()) != -1) {
            line.advance();
        }
        if (line.at() == mark) {
            return null;
        }
        return errors.logParsingToken(new ExprToken(loc.copySetEnd(line.at() - 1), 4, line.fromMark(mark)));
    }

    public ExprToken original(String o) {
        this.original = o;
        return this;
    }

    public String toString() {
        return "ET[" + this.type + ":" + this.text + "]";
    }
}

