/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.tokenizers;

import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.grammar.tracking.LoggableToken;
import org.flasck.flas.tokenizers.Tokenizable;

public class EventZoneToken
implements LoggableToken {
    public static final int NAME = 1;
    public static final int NUMBER = 2;
    public static final int DOT = 3;
    public static final int COLON = 4;
    public static final int CARD = 5;
    public final InputPosition location;
    public final int type;
    public final String text;

    public EventZoneToken(InputPosition location, int type, String text) {
        this.location = location;
        this.type = type;
        this.text = text;
    }

    public static EventZoneToken from(ErrorReporter errors, Tokenizable line) {
        line.skipWS(errors);
        int mark = line.at();
        InputPosition pos = line.realinfo();
        if (!line.hasMore()) {
            return null;
        }
        if (Character.isLowerCase(line.nextChar())) {
            char ch;
            line.advance();
            while (line.hasMore() && ((ch = line.nextChar()) == '-' || Character.isLowerCase(ch) || Character.isDigit(ch))) {
                line.advance();
            }
            return errors.logParsingToken(new EventZoneToken(pos.copySetEnd(line.at()), 1, line.fromMark(mark)));
        }
        if (Character.isDigit(line.nextChar())) {
            line.advance();
            while (line.hasMore() && Character.isDigit(line.nextChar())) {
                line.advance();
            }
            return errors.logParsingToken(new EventZoneToken(pos.copySetEnd(line.at()), 2, line.fromMark(mark)));
        }
        if (line.nextChar() == '.') {
            line.advance();
            return errors.logParsingToken(new EventZoneToken(pos.copySetEnd(line.at()), 3, line.fromMark(mark)));
        }
        if (line.nextChar() == ':') {
            line.advance();
            return errors.logParsingToken(new EventZoneToken(pos.copySetEnd(line.at()), 4, line.fromMark(mark)));
        }
        if (line.nextChar() == '_') {
            line.advance();
            return errors.logParsingToken(new EventZoneToken(pos.copySetEnd(line.at()), 5, line.fromMark(mark)));
        }
        return null;
    }

    public String toString() {
        return "EZT[" + this.text + ":" + this.location + "]";
    }

    @Override
    public InputPosition location() {
        return this.location;
    }

    @Override
    public String type() {
        switch (this.type) {
            case 1: 
            case 5: {
                return "zone-name";
            }
        }
        return "EventZoneToken";
    }

    @Override
    public String text() {
        return this.text;
    }
}

