/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.testsupport.matchers;

import java.util.ArrayList;
import java.util.List;
import org.flasck.flas.commonBase.Pattern;
import org.flasck.flas.parsedForm.TypedPattern;
import org.flasck.flas.testsupport.matchers.PatternMatcher;
import org.hamcrest.Description;

public class TypedPatternMatcher
extends PatternMatcher {
    private final String type;
    private final String var;
    private final List<String> typevars = new ArrayList<String>();

    public TypedPatternMatcher(String type, String var) {
        this.type = type;
        this.var = var;
    }

    public void describeTo(Description arg0) {
        arg0.appendText("Typed<");
        arg0.appendValue((Object)this.type);
        arg0.appendText(":");
        arg0.appendValue((Object)this.var);
        arg0.appendText(">");
    }

    protected boolean matchesSafely(Pattern arg0) {
        if (arg0 instanceof TypedPattern) {
            TypedPattern patt = (TypedPattern)arg0;
            if (!this.var.equals(patt.var.var) || !this.type.equals(patt.type.name())) {
                return false;
            }
            if (this.typevars.size() != patt.type.polys().size()) {
                return false;
            }
            for (int i = 0; i < this.typevars.size(); ++i) {
                if (this.typevars.get(i).equals(patt.type.polys().get(i).name())) continue;
                return false;
            }
        }
        return true;
    }

    public TypedPatternMatcher typevar(String tv) {
        this.typevars.add(tv);
        return this;
    }
}

