/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.testsupport.matchers;

import java.util.ArrayList;
import java.util.List;
import org.flasck.flas.commonBase.Pattern;
import org.flasck.flas.parsedForm.TuplePattern;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class TuplePatternMatcher
extends TypeSafeMatcher<Pattern> {
    private final List<MemberMatcher> members = new ArrayList<MemberMatcher>();

    public void describeTo(Description arg0) {
        arg0.appendText("Tuple<");
        arg0.appendValue(this.members);
        arg0.appendText(">");
    }

    protected boolean matchesSafely(Pattern arg0) {
        if (arg0 instanceof TuplePattern) {
            TuplePattern cm = (TuplePattern)arg0;
            if (this.members.size() != cm.args.size()) {
                return false;
            }
            for (int i = 0; i < this.members.size(); ++i) {
                if (this.members.get(i).matches(cm.args.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static TuplePatternMatcher tuple() {
        return new TuplePatternMatcher();
    }

    public TuplePatternMatcher member(Matcher<Pattern> m) {
        this.members.add(new MemberMatcher(m));
        return this;
    }

    public static class MemberMatcher
    extends TypeSafeMatcher<Pattern> {
        private final Matcher<Pattern> m;

        public MemberMatcher(Matcher<Pattern> m) {
            this.m = m;
        }

        public void describeTo(Description arg0) {
            arg0.appendText("Member[");
            arg0.appendValue(this.m);
            arg0.appendText("]");
        }

        protected boolean matchesSafely(Pattern patt) {
            return this.m.matches((Object)patt);
        }
    }
}

